/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: tstruct_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Type_struct F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_type_struct_(c, b, d, t, nt, ierr)

int			*c, *b,	*d, *t,	*nt, *ierr;

{
	MPI_Datatype	dtype;
	MPI_Datatype	*tp;
	MPI_Aint	*dp;
	int		i;

	tp = (MPI_Datatype *) malloc((unsigned)	(*c) * sizeof(MPI_Datatype));
	if (tp == 0) {
		*ierr =	lam_mkerr(MPI_ERR_OTHER, errno);
		return;
	}

	dp = (MPI_Aint *) malloc((unsigned) (*c) * sizeof(MPI_Aint));
	if (dp == 0) {
		free((char *) tp);
		*ierr =	lam_mkerr(MPI_ERR_OTHER, errno);
		return;
	}

	for (i = 0; i <	*c; ++i) {
		tp[i] =	GETHDL(t[i]);
		dp[i] =	(MPI_Aint) d[i];
	}

	*ierr =	MPI_Type_struct(*c, b, dp, tp, &dtype);
	lam_F_maketype(nt, ierr, (void *) dtype);

	free((char *) tp);
	free((char *) dp);
}
