/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: getprocname.c,v 6.1 96/11/23 22:52:00 nevin Rel $
 *
 *	Function:	- get the host name
 *	Accepts:	- name buffer (returned value)
 *			- ptr name length (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

extern int		gethostname();


int
MPI_Get_processor_name(name, len)

char			*name;
int			*len;

{
	lam_initerr();
	lam_setfunc(BLKMPIGETPNAME);

	if (gethostname(name, MPI_MAX_PROCESSOR_NAME - 1)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIGETPNAME,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	} else {
		name[MPI_MAX_PROCESSOR_NAME - 1] = '\0';
		*len = strlen(name);
	}

	lam_resetfunc(BLKMPIGETPNAME);
	return(MPI_SUCCESS);
}
