/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: graphdimsget.c,v 6.1 96/11/23 22:52:11 nevin Rel $
 *
 *	Function:	- get # nodes/edges in graph topology
 *	Accepts:	- communicator
 *			- ptr # nodes (returned value)
 *			- ptr # edges (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Graphdims_get(comm, pnodes, pedges)

MPI_Comm		comm;
int			*pnodes;
int			*pedges;

{
	lam_initerr();
	lam_setfunc(BLKMPIGRAPHDIMSGET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGRAPHDIMSGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHDIMSGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_GRAPH(comm)) {
		return(lam_errfunc(comm, BLKMPIGRAPHDIMSGET,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((pnodes == 0) || (pedges == 0)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHDIMSGET, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pnodes = comm->c_topo_nprocs;
	*pedges = comm->c_topo_nedges;

	lam_resetfunc(BLKMPIGRAPHDIMSGET);
	return(MPI_SUCCESS);
}
