/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: gunion.c,v 6.1 96/11/23 22:52:24 nevin Rel $
 *
 *	Function:	- form the union of two groups
 *	Accepts:	- first group
 *			- second group
 *			- ptr union group
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>

int
MPI_Group_union(g1, g2, pgu)

MPI_Group		g1;
MPI_Group		g2;
MPI_Group		*pgu;

{
	int		i, j;			/* favourite indices */
	int		nproc;			/* # procs in union */
	struct _proc	**pi, **pj;		/* favourite pointers */
	MPI_Group	gu;			/* union group */

	lam_initerr();
	lam_setfunc(BLKMPIGROUPUNION);
/*
 * Check the arguments.
 */
	if ((g1 == MPI_GROUP_NULL) || (g2 == MPI_GROUP_NULL)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPUNION, lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if (pgu == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPUNION, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial cases.
 */
	if (g1->g_nprocs == 0) {
		*pgu = g2;
		g2->g_refcount++;
		lam_resetfunc(BLKMPIGROUPUNION);
		return(MPI_SUCCESS);
	}

	if (g2->g_nprocs == 0) {
		*pgu = g1;
		g1->g_refcount++;
		lam_resetfunc(BLKMPIGROUPUNION);
		return(MPI_SUCCESS);
	}
/*
 * Get the # of processes in the union.
 * Flag the duplicate processes in second group.
 */
	nproc = g1->g_nprocs + g2->g_nprocs;

	for (i = 0, pi = g2->g_procs; i < g2->g_nprocs; ++i, ++pi) {

		for (j = 0, pj = g1->g_procs; j < g1->g_nprocs; ++j, ++pj) {

			if (*pi == *pj) {
				(*pi)->p_mode |= LAM_PFLAG;
				--nproc;
				break;
			}
		}
	}
/*
 * Allocate a new group.
 */
	gu = (MPI_Group) malloc((unsigned) sizeof(struct _group) +
					(nproc * sizeof(struct _proc *)));
	if (gu == 0) {
		for (i = 0, pi = g2->g_procs; i < g2->g_nprocs; ++i, ++pi) {
			(*pi)->p_mode &= ~LAM_PFLAG;
		}

		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIGROUPUNION,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*pgu = gu;
	gu->g_myrank = MPI_UNDEFINED;
	gu->g_nprocs = nproc;
	gu->g_refcount = 1;
	gu->g_procs = (struct _proc **) ((char *) gu + sizeof(struct _group));
/*
 * Fill the new group processes.
 */
	memcpy((char *) gu->g_procs, (char *) g1->g_procs,
				g1->g_nprocs * sizeof(struct _proc *));

	pj = gu->g_procs + g1->g_nprocs;

	for (i = 0, pi = g2->g_procs; i < g2->g_nprocs; ++i, ++pi) {

		if ((*pi)->p_mode & LAM_PFLAG) {
			(*pi)->p_mode &= ~LAM_PFLAG;
		} else {
			*pj = *pi;
			++pj;
		}
	}

	for (i = 0, pi = gu->g_procs; i < gu->g_nprocs; ++i, ++pi) {
		(*pi)->p_refcount++;
		if (*pi == lam_myproc) {
			gu->g_myrank = i;
		}
	}

	lam_resetfunc(BLKMPIGROUPUNION);
	return(MPI_SUCCESS);
}
