/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: irsend.c,v 6.1 96/11/23 22:52:43 nevin Rel $
 *
 *	Function:	- immediate ready-mode send
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *			- request (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_msg();
extern int		lam_errfunc();
extern int		lam_isend();
extern int		lam_tr_incff();

int
MPI_Irsend(buf, count, dtype, dest, tag, comm, req)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
MPI_Request		*req;

{
	int		err;
	int		fl_trace;		/* do tracing? */
	double		startt;			/* start time */
	double		finisht;		/* finish time */

	lam_initerr();
	lam_setfunc(BLKMPIIRSEND);

	if ((fl_trace = LAM_TRACE_TOP())) startt = MPI_Wtime();

/*
 * Start the send.
 */
	err = lam_isend(buf, count, dtype, dest, tag, comm, req,
			LAM_RQIRSEND);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIIRSEND, err));
	}
/*
 * Generate a run time trace.
 */
	if (fl_trace) {
		finisht = MPI_Wtime();

		lam_tr_msg(TRTOUTPUT, startt, LAM_S2US(finisht - startt), 0,
				dest, tag, comm, dtype, count, 0, 0, 
				(*req)->rq_seq, LAM_RQIRSEND);
	}

	lam_resetfunc(BLKMPIIRSEND);
	return(MPI_SUCCESS);
}
