/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: m2l.c,v 6.1 96/11/23 22:53:24 nevin Rel $
 *
 *	Function:	- mapping between MPI synchronization and LAM's
 *			  network messages
 */

#include <app_mgmt.h>
#include <mpi.h>
#include <mpisys.h>
#include <net.h>
#include <rpisys.h>

/*
 * global functions
 */
void			_m2l_ack();
void			_m2l_fill();
void			_m2l_tail();
struct _proc		*_m2l_getsource();
int			_m2l_gettag();

/*
 *	_m2l_fill
 *
 *	Function:	- fills MPI synchronization info into LAM
 *			  network message
 *	Accepts:	- ptr source process (or NULL)
 *			- ptr destination process
 *			- tag
 *			- context ID
 *			- network message header (filled)
 */
void
_m2l_fill(proc_src, proc_dest, tag, cid, msg)

struct _proc		*proc_src;
struct _proc		*proc_dest;
int			tag;
int			cid;
struct nmsg		*msg;

{
	msg->nh_node = proc_dest->p_gps.gps_node;

	msg->nh_event = ((cid & 0x1FFF) << 18) |
			(proc_dest->p_gps.gps_idx & 0x7FFF);

	if (proc_src == 0) {
		msg->nh_type = 0xFFFF0000;
	} else {
		msg->nh_type = (((proc_src->p_gps.gps_idx & 0x1F) << 10) |
				(proc_src->p_gps.gps_node & 0x3FF)) << 16;
	}

	if (tag < 0) {
		tag &= 0xFFFF;
	} else {
		tag &= 0x7FFF;
	}

	msg->nh_type |= tag;
}

/*
 *	_m2l_ack
 *
 *	Function:	- modify LAM network message for MPI ack
 *			  synchronization
 *	Accepts:	- network message
 */
void
_m2l_ack(msg)

struct nmsg		*msg;

{
	msg->nh_event |= 0x10000;
}

/*
 *	_m2l_tail
 *
 *	Function:	- modify LAM network message for MPI tail data
 *			  synchronization
 *	Accepts:	- network message
 */
void
_m2l_tail(msg)

struct nmsg		*msg;

{
	msg->nh_event |= 0x20000;
}

/*
 *	_m2l_getsource
 *
 *	Accepts:	- network message
 *	Returns:	- MPI source process
 */
struct _proc *
_m2l_getsource(msg)

struct nmsg		*msg;

{
	struct _gps	source;

	source.gps_node = (msg->nh_type & 0x03FF0000) >> 16;
	source.gps_idx = (msg->nh_type & 0x7C000000) >> 26;
	return(lam_procfind(&source));
}

/*
 *	_m2l_gettag
 *
 *	Accepts:	- network message
 *	Returns:	- MPI message tag
 */
int
_m2l_gettag(msg)

struct nmsg		*msg;

{
	return(msg->nh_type & 0xFFFF);
}
