/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: portclose.c,v 6.1 96/11/22 13:35:06 nevin Rel $
 *
 *	Function:	- close an MPI port
 *	Accepts:	- port name
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>


int
MPI_Port_close(port_name)

char			*port_name;

{
	struct _port	search;			/* search key for port */
	struct _port	*port;			/* found port */

	lam_initerr();
	lam_setfunc(BLKMPIPORTCLOSE);

	if (strlen(port_name) > LAM_PORTLEN) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTCLOSE,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Find the port.
 */
	strncpy(search.prt_name, port_name, LAM_PORTLEN);

	port = al_find(lam_ports, &search);
	if (port == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTCLOSE,
					lam_mkerr(MPI_ERR_OTHER, ENOENT)));
	}
/*
 * close it
 */
	if (lam_port_close(port->prt_num)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTCLOSE,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}
	if (al_delete(lam_ports, port)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTCLOSE,
					lam_mkerr(MPI_ERR_INTERN, 0)));
	}

        lam_resetfunc(BLKMPIPORTCLOSE);
	return(MPI_SUCCESS);
}
