/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: send.c,v 6.1 96/11/23 22:54:04 nevin Rel $
 *
 *	Function:	- send a message in standard mode
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern int		lam_send();

int
MPI_Send(buf, count, dtype, dest, tag, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;

{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPISEND);

	err = lam_send(buf, count, dtype, dest, tag, comm, LAM_RQISEND);

	lam_resetfunc_m(BLKMPISEND);

	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPISEND, err));

	return(MPI_SUCCESS);
}
