/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: testall.c,v 6.1 96/11/23 22:54:29 nevin Rel $
 *
 *	Function:	- check if all requests completed
 *	Accepts:	- # of requests
 *			- array of requests
 *			- flag (returned)
 *			- array of status structures (modified)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*
 * external functions
 */
extern void		lam_emptystat();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_wrapend();
extern int		lam_tr_wrapstart();
extern int		lam_test();
extern int		lam_mkerr();


int
MPI_Testall(count, reqs, flag, stats)

int			count;
MPI_Request		*reqs;
int			*flag;
MPI_Status		*stats;

{
	int		i;			/* favourite index */
	int		fl_done;		/* request done? */
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	MPI_Request	*req;			/* ptr request */
	MPI_Status	*stat;			/* ptr status */

	lam_initerr();
	lam_setfunc(BLKMPITESTALL);

	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTALL,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((count > 0) && ((reqs == 0) || (stats == 0))) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTALL,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (flag == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTALL,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPITESTALL);
	}
/*
 * Initialize all status members.
 */
	for (i = 0, stat = stats; i < count; ++i, ++stat) {
		lam_emptystat(stat);
	}
/*
 * Loop testing all requests non-destructively.
 * Stop at the first request not done.
 */
	req = reqs;
	stat = stats;

	for (i = 0; i < count; ++i, ++req, ++stat) {

		err = lam_test(req, 0, &fl_done, stat);

		if (err != MPI_SUCCESS) {
			stat->MPI_ERROR = err;

			if (fl_trace) {
				lam_tr_wrapend(BLKMPITESTALL);
			}

			lam_resetfunc(BLKMPITESTALL);
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTALL,
					lam_mkerr(MPI_ERR_IN_STATUS, 0)));
		}

		if (fl_done == 0) {
			*flag = 0;

			if (fl_trace) {
				lam_tr_wrapend(BLKMPITESTALL);
			}

			lam_resetfunc(BLKMPITESTALL);
			return(MPI_SUCCESS);
		}
	}
/*
 * All active requests are done, loop doing the job.
 */
	req = reqs;
	stat = stats;

	for (i = 0; i < count; ++i, ++req, ++stat) {
		err = lam_test(req, 1, &fl_done, stat);

		if (err != MPI_SUCCESS) {
			stat->MPI_ERROR = err;

			if (fl_trace) {
				lam_tr_wrapend(BLKMPITESTALL);
			}

			lam_resetfunc(BLKMPITESTALL);
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTALL,
					lam_mkerr(MPI_ERR_IN_STATUS, 0)));
		}
	}

	*flag = 1;
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
		lam_tr_wrapend(BLKMPITESTALL);
	}

	lam_resetfunc(BLKMPITESTALL);
	return(MPI_SUCCESS);
}
