/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	getnodes.c,v $
 * Revision 6.1  96/11/24  00:22:53  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:01:04  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/18  20:08:07  gdburns
 * Use msg type RSMART.
 * 
 * Revision 5.2  94/08/22  14:10:00  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:46:21  gdburns
 * upgrade for new kernel
 * 
 * Revision 5.1  94/05/18  12:57:23  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:45:50  gdburns
 * Ohio Release
 * 
 *	Function:	- multiple node route matching
 */

#include <events.h>
#include <net.h>
#include <rreq.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;

/*
 *	getnodes
 *
 *	Function:	- gets matching node IDs from local router
 *	Accepts: 	- node array
 *			- # array elements
 *			- node type
 *			- node type mask
 *	Returns:	- 0 or ERROR
 */
int
getnodes(pnodes, nnodes, nodetype, typemask)

int4			*pnodes;
int4			nnodes;
int4			nodetype;
int4			typemask;

{
	struct rreq	*request;	/* router request */
	struct rreply	*reply;		/* router reply */
	struct nmsg	nhreq;		/* request message */
	struct nmsg	nhreply;	/* reply message */
/*
 * Set up the router request.
 */
	request = (struct rreq *) nhreq.nh_data;
	request->rq_src_event = -getpid();
	request->rq_request = RQGETNODES;
	request->rq_pid = getpid();		/* for sa_rtr */
	request->rq_nodetype = nodetype;
	request->rq_typemask = typemask;

	nhreq.nh_dl_event = EVROUTER;
	nhreq.nh_node = LOCAL;
	nhreq.nh_event = EVROUTER;
	nhreq.nh_type = RSMART;
	nhreq.nh_flags = 0;
	nhreq.nh_length = 0;
	nhreq.nh_msg = 0;

	nhreply.nh_event = -getpid();
	nhreply.nh_type = 0;
	nhreply.nh_flags = 0;
	nhreply.nh_length = nnodes * sizeof(int);
	nhreply.nh_msg = (char *) pnodes;

	if (dsfr(&nhreq, &nhreply)) {
		return(ERROR);
	}

	reply = (struct rreply *) nhreply.nh_data;

	if (reply->rr_reply) {
		errno = reply->rr_reply;
		return(ERROR);
	} else {
		return(0);
	}
}

/*
 *	getntype
 *
 *	Returns:	- # of nodes with types satisfying the
 *			  given type in all bits that are set
 *			  in the given mask
 *	Accepts:	- nodetype bitfield value
 *			- nodetype bitfield mask
 */
int4
getntype(node_type, type_mask)

int4 			node_type;
int4			type_mask;

{
	struct rreq	*request;	/* router request */
	struct rreply	*reply;		/* router reply */
	struct nmsg	nhreq;		/* request message */
	struct nmsg	nhreply;	/* reply message */
/*
 * Set up the router request.
 */
	request = (struct rreq *) nhreq.nh_data;
	request->rq_src_event = -getpid();
	request->rq_request = RQGETNTYPE;
	request->rq_nodetype = node_type;
	request->rq_typemask = type_mask;

	nhreq.nh_dl_event = EVROUTER;
	nhreq.nh_node = LOCAL;
	nhreq.nh_event = EVROUTER;
	nhreq.nh_type = RSMART;
	nhreq.nh_flags = 0;
	nhreq.nh_length = 0;
	nhreq.nh_msg = 0;

	nhreply.nh_event = -getpid();
	nhreply.nh_type = 0;
	nhreply.nh_flags = 0;
	nhreply.nh_length = 0;
	nhreply.nh_msg = 0;

	if (dsfr(&nhreq, &nhreply)) {
		return(ERROR);
	}

	reply = (struct rreply *) nhreply.nh_data;

	if (reply->rr_reply) {
		errno = reply->rr_reply;
		return(ERROR);
	} else {
		return(reply->rr_ntype);
	}
}
