/*
 *	Ohio Trollius
 *	(public domain software)
 *
 *	$Log:	tfflush.c,v $
 * Revision 6.1  96/11/24  00:35:54  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:28  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:32  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:46  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:52  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/05/10  16:36:57  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <sys/types.h>
#include <tstdio.h>

/*
 * external functions
 */
extern int		iomap_write();
extern off_t		iomap_lseek();

/*
 *	implementation note:  This function has the side effect of
 *	re-aligning the virtual file pointer (in the buffer) with
 *	the actual file pointer (in the file) and is therefore used
 *	in other functions to accomplish this re-sync operation.
 */

static int
_fflush(fp)
	TFILE *fp;
{
	int f, rv = 0;
	long offset;

 	if(fp == NULL)
		return(0);
	f = fp->_flag;
	if((f & _TIONBF)			/* MB: file is not buffered */
	|| (!(f & (_TIOREAD | _TIOWRT))))		/* file not open! */
		return(0);
	if(fp->_cnt)				/* data in the buffer */
	{
		if(f & _TIORW)				/* writing */
		{
			if((iomap_write(f, fp->_file, (char *) fp->_base,
				(long) fp->_cnt)) != fp->_cnt)
			{
				fp->_flag |= _TIOERR;
				rv = EOF;
			}

		} else {				/* reading */

			offset = (long) -(fp->_cnt);
			if(iomap_lseek(f, fp->_file, offset, 1) < 0)
				rv = EOF;
		}
	}
	fp->_ptr = fp->_base;
	fp->_cnt = 0;
	return(rv);
}

int
tfflush(fp)
	TFILE *fp;
{
	int f, i;

 	if(fp)
		return(_fflush(fp));
	else {
		for(i=0; i<_TNFILE; ++i) {
			f = _tiob[i]._flag;
			if(f & (_TIOREAD | _TIOWRT))
				(void) _fflush(&_tiob[i]);
		}
		return(0);
	}
}
