/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: hf77.c,v 6.1 96/11/23 19:37:12 nevin Rel $
 *
 *	Function:	- wrapper for FORTRAN program compilation
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <args.h>
#include <boot.h>
#include <portable.h>

#ifndef DEFTF77
#if HPUX
#define DEFTF77 "fort77"
#else
#define DEFTF77 "f77"
#endif
#endif

/*
 * external functions
 */
extern int		cnfexec();

/*
 * local variables
 */
static char		plib[LAM_PATH_MAX];

int
main(argc, argv)

int			argc;
char			*argv[];

{
	int		ac;		/* f77 # args */
	int		status;		/* f77 return code */
	int		fl_libs;	/* add libs to command line */
	int		fl_show;	/* show what would be done */
	int		i;		/* favourite index */
	char		**av;		/* f77 arg vector */
	char		**sys;		/* system libraries arg vector */
	char		*phome;		/* installation dir */
	char		*tf77;		/* f77 tool */

	phome = getenv("LAMHOME");
	if (phome == 0) phome = getenv("TROLLIUSHOME");
	if (phome == 0) phome = DEFP;

	if ((strlen(phome) + 32) >= LAM_PATH_MAX) {
		fprintf(stderr, "hf77: LAM home pathname too long\n");
		exit(1);
	}
/*
 * Form library directory pathname.
 */
	strcpy(plib, "-L");
	strcat(plib, phome);
	strcat(plib, STRSDIR);
	strcat(plib, "lib");

	tf77 = getenv("LAMHF77");
	if (tf77 == 0) tf77 = getenv("TROLLIUSHF77");
	if (tf77 == 0) tf77 = DEFTF77;

	ac = 0;
	av = 0;
	argvadd(&ac, &av, tf77);

	fl_show = 0;
	fl_libs = 1;

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme") == 0) {
			fl_show = 1;
		} else if (strcmp(argv[i], "-c") == 0) {
			fl_libs = 0;
		}
	}

	if (fl_libs) {
		argvadd(&ac, &av, plib);
	}

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme")) {
			argvadd(&ac, &av, argv[i]);
		}
	}

	if (fl_libs) {
		argvadd(&ac, &av, "-ltstdio");
		argvadd(&ac, &av, "-ltrillium");
		argvadd(&ac, &av, "-largs");
		argvadd(&ac, &av, "-lt");
/*
 * Add system dependent libraries.
 */
		if (strlen(SYSLIBS) > 0) {
			if ((sys = argvbreak(SYSLIBS, ' ')) == 0) {
				perror("hf77");
				exit(errno);
			}

			for ( ; *sys; sys++) {
				argvadd(&ac, &av, *sys);
			}
		}
	}

	if (fl_show) {
		for (i = 0; i < ac; i++) {
			printf("%s ", av[i]);
		}
		printf("\n");
	} else {
		status = cnfexec(av);

		if (status) {
			perror(tf77);
			exit(status);
		}
	}

	return(0);
}
