// testAnyClient.cc
//

#include <iostream.h>
#include <string.h>
#include <stdlib.h>

#include <common/common.h>

#include "anyParse.h"

#include "anyStructTest.hh"


// Change the function below to display the type being tested.


static CORBA::Boolean viewStruct(const CORBA::Any& a)
{
  structLong* aStr;
  structDouble1* bStr;
  structDouble2* cStr;
  structVariable* dStr;
  
  seqStruct* aSeq;
  arrayStruct_forany aArr;

  structSequence* eStr;
  structArray* fStr;
  structStruct* gStr;

  CORBA::Any b;

  if (a >>= b)
    {
      cout << "Any contains any: " << endl;
      return viewStruct(b);
    }  
  else if (a >>= aStr)
    {
      cout << "structLong: " << endl;    
      cout << "Long: " << aStr->l << endl;
      cout << "Short: " << aStr->s << endl;
      return 1;
    }
  else if (a >>= bStr)
    {
      cout << "structDouble1: " << endl;    
      cout << "Double: " << bStr->d << endl;
      cout << "Long: " << bStr->l  << endl;
      return 1;
    }
  else if (a >>= cStr)
    {
      cout << "structDouble2: " << endl;
      cout << "Short: " << cStr->l  << endl;
      cout << "Double: " << cStr->d << endl;

      cout << "-- [Test extracting again] --" << endl;
      structDouble2* tmpStr;

      a >>= tmpStr;
      cout << "Short: " << tmpStr->l  << endl;
      cout << "Double: " << tmpStr->d << endl;

      return 1;
    }
  else if (a >>= dStr)
    {
      cout << "structVariable: " << endl;
      cout << "String: _" << dStr->str << "_" << endl;
      cout << "Double: " << dStr->d << endl;
      return 1;
    }
  else if (a >>= aSeq)
    {
      cout << "seqStruct: " << endl;
      cout << "Number of members: " << aSeq->length() << endl;
      CORBA::ULong count = 0;
      for (count = 0; count < aSeq->length(); count++)
	{
	  cout << "[" << count << "]" << endl;
	  cout << "String: " << ((*aSeq)[count]).str << endl;
	  cout << "Double: " << ((*aSeq)[count]).d << endl;
	}
      return 1;
    }
  else if (a >>= aArr)
    {
      cout << "arrayStruct: " << endl;
      for (CORBA::ULong count = 0; count < 2; count++)
	{
	  cout << "[" << count << "]" << endl;
	  cout << "String: " << aArr[count].str << endl;
	  cout << "Double: " << aArr[count].d << endl;
	}
      return 1;
    }
  else if (a >>= eStr)
    {
      cout << "structSequence: " << endl;
      cout << "  seqStruct: " << endl;
      cout << "    Number of members: " << (eStr->s).length() << endl;
      CORBA::ULong count = 0;
      for (count = 0; count < (eStr->s).length(); count++)
	{
	  cout << "    [" << count << "]" << endl;
	  cout << "    String: " << ((eStr->s)[count]).str << endl;
	  cout << "    Double: " << ((eStr->s)[count]).d << endl;
	}
      cout << "Double: " << eStr->d << endl;

      cout << "-- [Test extracting again] --" << endl;

      structSequence* tmpStr;
      a >>= tmpStr;
      cout << "  seqStruct: " << endl;
      cout << "    Number of members: " << (tmpStr->s).length() << endl;
      for (count = 0; count < (tmpStr->s).length(); count++)
	{
	  cout << "    [" << count << "]" << endl;
	  cout << "    String: " << ((tmpStr->s)[count]).str << endl;
	  cout << "    Double: " << ((tmpStr->s)[count]).d << endl;
	}
      cout << "Double: " << tmpStr->d << endl;
      return 1;
    }
  else if (a >>= fStr)
    {
      cout << "structArray: " << endl;
      cout << "  arrayStruct:" << endl;
      for (CORBA::ULong count = 0; count < 2; count++)
	{
	  cout << "    [" << count << "]" << endl;
	  cout << "    String: " << ((fStr->ar)[count]).str << endl;
	  cout << "    Double: " << ((fStr->ar)[count]).d << endl;
	}
      
      cout << "Double: " << fStr->d << endl;
      return 1;
    }
  else if (a >>= gStr)
    {
      cout << "structStruct:" << endl;
      cout << "Double: " << gStr->d << endl;

      cout << "  structSequence:" << endl;
      cout << "    seqStruct: " << endl;
      cout << "      Number of members: " << ((gStr->st).s).length() << endl;
      for (CORBA::ULong count = 0; count < ((gStr->st).s).length(); count++)
	{
	  cout << "      [" << count << "]" << endl;
	  cout << "      String: " << (((gStr->st).s)[count]).str << endl;
	  cout << "      Double: " << (((gStr->st).s)[count]).d << endl;
	}
      cout << "    Double: " << (gStr->st).d << endl;
      return 1;
    }     
  else return 0;
}



static void viewAny(const CORBA::Any& a)
{
  if (!anyParse::parse(a))
    {
      if (!viewStruct(a))
	{
	  cerr << "Unknown type contained in any. Test failed." << endl;
	  exit(-1);
	}
    }
}


static void testAny(anyStructTest_ptr tObj, CORBA::Any& a, CORBA::Any& b, 
		    CORBA::ULong& pass)
{
  CORBA::Any* c;
  CORBA::Any* rc;

  cout << "\n\nPass: " << pass++ << endl;

  cout << "** Outbound Anys:" << endl;
  cout << "a: ";
  viewAny(a);

  cout << "b: ";
  viewAny(b);

  cout << "Invoking method." << endl;
  rc = tObj->testOp(a,b,c);

  cout << "\n** Returned Anys: " << endl;
  cout << "b: ";
  viewAny(b);

  cout << endl;
  
  cout << "c: ";  viewAny(*c);
  cout << "Return value: "; viewAny(*rc);

  cout << "------------------------" << endl;
  delete c; 
  delete rc;
}


int main(int argc, char* argv[])
{

  CORBA::ORB_ptr orb;
  orb = CORBA::ORB_init(argc,argv,"omniORB2");
  // Obtain a reference to the root context of the Name service:

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: testAnyClient -i <stringified IOR>" << endl;
    cerr << "       testAnyClient <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }


  anyStructTest_var tObj;

  tObj = anyStructTest::_narrow(obj);

  if(CORBA::is_nil(tObj))
    {
      cerr << "Failed to narrow object." << endl;
      return -1;
    }

  CORBA::ULong pass = 1;

  CORBA::Any a,b;

  structLong aStr;
  structDouble1 bStr;
  structDouble2 cStr;
  structVariable dStr;
  
  seqStruct aSeq;
  arrayStruct aArr;

  structSequence eStr;
  structArray fStr;
  structStruct gStr;
  

  aStr.l = 9876543;
  aStr.s = 3;

  bStr.d = 8.123456;
  bStr.l = 9876543;

  cStr.l = 3;
  cStr.d = 8.123456;

  dStr.str = CORBA::string_dup("Hello there!");
  dStr.d = 15.654321;

  aSeq.length(3);
  aSeq[0].str = CORBA::string_dup("Hello 0.");
  aSeq[0].d = 0.1;
  aSeq[1].str = CORBA::string_dup("Hello 1.");
  aSeq[1].d = 1.1;
  aSeq[2].str = CORBA::string_dup("Hello 2.");
  aSeq[2].d = 2.1;

  aArr[0].str = CORBA::string_dup("Hello Again 0.");
  aArr[0].d = 0.2;
  aArr[1].str = CORBA::string_dup("Hello Again 1.");
  aArr[1].d = 1.2;

  eStr.s = aSeq;
  eStr.d = 8.123456;
  fStr.ar[0] = aArr[0];
  fStr.ar[1] = aArr[1];
  fStr.d = 9.123456;

  gStr.d = 8.123456;
  structSequence eStr2;
  eStr2.s = aSeq;
  eStr2.d = 77.88;
  gStr.st = eStr2;
    

  // Tests:

  a <<= (CORBA::Double) 12321.231;
  b <<= aStr;
  testAny(tObj,a,b,pass);

  a <<= (CORBA::Double) 12321.231;
  b <<= bStr;
  testAny(tObj,a,b,pass);

  a <<= (CORBA::Double) 12321.231;
  b <<= cStr;
  testAny(tObj,a,b,pass);

  a <<= (CORBA::ULong) 43231;
  b <<= dStr;
  testAny(tObj,a,b,pass);

  a <<= (CORBA::ULong) 43231;
  b <<= aSeq;
  testAny(tObj,a,b,pass);

  a <<= (CORBA::ULong) 43231;
  b <<= arrayStruct_forany(aArr);
  testAny(tObj,a,b,pass);
  
  a <<= (CORBA::ULong) 43231;
  b <<= eStr;
  testAny(tObj,a,b,pass);
  
  a <<= (CORBA::ULong) 43231;
  b <<= fStr;
  testAny(tObj,a,b,pass);

  a <<= (CORBA::ULong) 43231;
  b <<= gStr;
  testAny(tObj,a,b,pass);


  a <<= (CORBA::ULong) 43231;
  CORBA::Any d;
  d <<= gStr;
  b <<= d;
  testAny(tObj,a,b,pass);


  cout << "Finished!" << endl;


  return 1;
}
