// Testing code: implementation of attrEcho objects
//
// interface attrEcho {
//    attribute string a1;
//    readonly attribute string a2;
//    readonly attribute long a3;
//    attribute long a4;
// };
//

#include <iostream.h>
#include <string.h>
#include <attrEcho.hh>
#include <common/common.h>

// implementation using inheritance skeleton
class attrEcho_i : public virtual _sk_attrEcho {
public:
  attrEcho_i() { pd_string = 0; }
  virtual char *  a1 ();
  virtual void a1 (const char *  _value);
  virtual char *  a2 () {
    char *_result = CORBA::string_alloc(0);
    _result[0] = '\0';
    return _result;
  }
  virtual CORBA::Long  a3 () { return 0; }
  virtual CORBA::Long  a4 () { return 1; }
  virtual void a4 (CORBA::Long  _value) { return; }

private:
  char * pd_string;

};

void
attrEcho_i::a1(const char * _value) {
  if (pd_string) {
    CORBA::string_free(pd_string);
    pd_string = 0;
  }
  pd_string = CORBA::string_alloc(strlen((const char*)_value));
  strcpy((char *)pd_string,(const char *)_value);
  return;
}

char *
attrEcho_i::a1() {
  char *_result;
  if (pd_string) {
    _result = CORBA::string_alloc(strlen((const char*)pd_string));
    strcpy(_result,(const char*)pd_string);
  }
  else {
    _result = CORBA::string_alloc(0);
    _result[0] = '\0';
  }
  return _result;
}



int
main(int argc, char **argv) {

  try {

    CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
    CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

    CosNaming::Name use_name;
  
    if (argc > 1) {
      if (argc != 2) {
	cerr << "Usage: attrEchosrv [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	     << endl;
      }
      try {
	use_name = string_to_name(argv[1]);
      }
      catch (...) {
	cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
	return 1;
      }
    }


    attrEcho_i *myobj = new attrEcho_i();
    myobj->_obj_is_ready(boa);

    {
      attrEcho_var myobjRef = myobj->_this();
      if (use_name.length()) {
	if (!bindObjectToName(orb,myobjRef,use_name)) {
	  return 1;
	}
      }
      else {
	CORBA::String_var p = orb->object_to_string(myobjRef);
	cerr << (char*)p << endl;
      }
    }

    boa->impl_is_ready();
  }
  catch (const omniORB::fatalException &ex) {
      cerr << "#### You have caught an omniORB2 bug, details are as follows:" << endl;
      cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
      cerr << "main thread exited." << endl;
      return 1;
    }
  return 0;
}
