// Testing code: client of attrEcho objects
//
// interface attrEcho {
//    attribute string a1;
//    readonly attribute string a2;
//    readonly attribute long a3;
//    attribute long a4;
// };
//

#include <iostream.h>
#include <attrEcho.hh>
#include <common/common.h>

int
main (int argc, char **argv) {

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: attrEchoclt -i <stringified IOR>" << endl;
    cerr << "       attrEchoclt <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }

  attrEcho_var e = attrEcho::_narrow(obj);

  if (CORBA::is_nil(e))
    {
      cerr << "Can't create proxy.\n" << endl;
      return(1);
    }

  if (e->_non_existent()) {
    cerr << "Object does not exist.\n" << endl;
  }

  try {
    int loopcount = 10;
    while (loopcount--) {
      char * echostr;
      e->a1((char *)"abcde");
      echostr = e->a1();
      cerr << "reply " << echostr << endl;
      if (strcmp((const char *)echostr,"abcde")) {
	cerr << loopcount << " : echo string differs ('" << "abcde', '" 
	     << (char *)echostr << "')" << endl;
	break;
      }
      CORBA::string_free(echostr);
    }
  }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  return 0;
}
