// Testing code: implementation of multiEcho objects
//
//   interface Echo {
//        string echoString(in string mesg);
//   };
//
//   interface DerivedEcho : Echo {
//        long echoLong (in long arg1);
//   };
//
//
//   interface moreEcho {
//         char echoChar(in char arg1);
//   };
//
//   interface multiEcho : DerivedEcho, moreEcho {
//         boolean echoBool(in boolean arg1);
//   };
//
// Implement this using tie template

#include <iostream.h>
#include <string.h>
#include <multiEcho.hh>
#include <common/common.h>

// implementation using tie template
class multiEcho_i {
public:
  multiEcho_i() {}
  virtual char * echoString(const char *mesg);
  virtual CORBA::Long echoLong(CORBA::Long arg1);
  virtual CORBA::Char echoChar(CORBA::Char arg1);
  virtual CORBA::Boolean echoBool(CORBA::Boolean arg1);
};

char *
multiEcho_i::echoString(const char *mesg) {
  char *p = CORBA::string_alloc(strlen((const char*)mesg));
  strcpy((char *)p,(const char *)mesg);
  return p;
}

CORBA::Long
multiEcho_i::echoLong(CORBA::Long arg1) {
  return arg1;
}

CORBA::Char
multiEcho_i::echoChar(CORBA::Char arg1) {
  return arg1;
}

CORBA::Boolean
multiEcho_i::echoBool(CORBA::Boolean arg1) {
  return arg1;
}

int
main(int argc, char **argv) {

  try {

    CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
    CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

    CosNaming::Name use_name;
  
    if (argc > 1) {
      if (argc != 2) {
	cerr << "Usage: multiEchosrv [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	     << endl;
      }
      try {
	use_name = string_to_name(argv[1]);
      }
      catch (...) {
	cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
	return 1;
      }
    }

    multiEcho_i *myobj = new multiEcho_i();
    _tie_multiEcho<multiEcho_i,1> *mytieobj = new _tie_multiEcho<multiEcho_i,1>(myobj);
    mytieobj->_obj_is_ready(boa);

    {
      multiEcho_var myobjRef = mytieobj->_this();
      if (use_name.length()) {
	if (!bindObjectToName(orb,myobjRef,use_name)) {
	  return 1;
	}
      }
      else {
	CORBA::String_var p = orb->object_to_string(myobjRef);
	cerr << (char*)p << endl;
      }
    }

    boa->impl_is_ready();
  }
  catch (const omniORB::fatalException &ex) {
      cerr << "#### You have caught an omniORB2 bug, details are as follows:" << endl;
      cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
      cerr << "main thread exited." << endl;
      return 1;
    }
  return 0;
}
