// usage: server [<object COSnaming compound name (e.g. x/y/test.obj)>]
//
#include <iostream.h>
#include <inheritance_2.hh>
#include <common/common.h>

CORBA::BOA_ptr boa;

class D_i : public _sk_D {
public:
  D_i() { _obj_is_ready(boa); }
  ~D_i() {}
  CORBA::Long a() { return 1; }
  CORBA::Long b() { return 2; }
  CORBA::Long c() { return 3; }
  CORBA::Long d() { return 4; }
};

class G_i : public _sk_G {
public:
  G_i(D_ptr dp) { d = dp; _obj_is_ready(boa); }
  ~G_i() {}
  A_ptr get_a() { return A::_duplicate(d); }
  B_ptr get_b() { return B::_duplicate(d); }
  CORBA::Object_ptr o() { return CORBA::Object::_duplicate(d); }
private:
  D_var d;
  G_i();
};


int
main(int argc, char **argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name use_name;
  if (argc > 1) {
    try {
      use_name = string_to_name(argv[1]);
    }
    catch (...) {
      cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
      return 1;
    }
  }

  D_i* d = new D_i;
  G_i* myobj = new G_i(d->_this());
  {
    G_var myobjRef = myobj->_this();
    if (use_name.length()) {
      if (!bindObjectToName(orb,myobjRef,use_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << (char*)p << endl;
    }
  }
  boa->impl_is_ready();

  return 0;
}
