#include <iostream.h>
#include <common/common.h>
#include <shutdown.hh>

int
main (int argc, char **argv) 
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: shutdown -i <stringified IOR>" << endl;
    cerr << "       shutdown <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }


  Shutdown_var e = Shutdown::_narrow(obj);

  if (CORBA::is_nil(e)) {
    cerr << "offswitch: cannot invoke on a nil object reference.\n" << endl;
    return 0;
  }

  cerr << "Calling offswitch" << endl;
  e->off();

  omni_thread::sleep(1);
  return 0;
}

