// tcClient.cc
//

#include <iostream.h>


#include <common/common.h>

#include "typecodeParse.h"

#include "typecodeTest.hh"


int main(int argc, char* argv[])
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: tcClient -i <stringified IOR>" << endl;
    cerr << "       tcClient <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }


    typecodeTest_var tObj;
    tObj = typecodeTest::_narrow(obj);

    if(CORBA::is_nil(tObj))
      {
	cerr << "Failed to narrow object returned to type typecodeTest" 
	     << endl;
	return 1;
      }
    
    if (tObj->_non_existent()) {
      cerr << "Object does not exist.\n" << endl;
    }


    // aTC
    CORBA::TypeCode_var aTC = CORBA::TypeCode::_duplicate(CORBA::_tc_string);
    CORBA::TypeCode_var aTC_copy = CORBA::TypeCode::_duplicate(aTC);

    // bTC
    CORBA::EnumMemberSeq SeqEnm;
    SeqEnm.length(3);
    SeqEnm[0] = (const char*) "ZERO";
    SeqEnm[1] = (const char*) "ONE";
    SeqEnm[2] = (const char*) "TWO";
    CORBA::TypeCode_var inner_inner_innerTC  = orb->create_enum_tc(
				       "IDL:aEnum:1.0","aEnum",SeqEnm);
    CORBA::TypeCode_var inner_innerTC = orb->create_sequence_tc(50,inner_inner_innerTC);
    CORBA::TypeCode_var innerTC = orb->create_array_tc(25,inner_innerTC);
   
    CORBA::StructMemberSeq SeqStr;
    SeqStr.length(3);
    (SeqStr[0]).name = (const char*) "aTypedef";
    (SeqStr[0]).type = orb->create_alias_tc("IDL:anAlias:1.0","anAlias",innerTC);
    (SeqStr[0]).type_def = CORBA::IDLType::_nil();
    (SeqStr[1]).name = (const char*) "aBoolean";
    (SeqStr[1]).type = CORBA::TypeCode::_duplicate(CORBA::_tc_boolean);
    (SeqStr[1]).type_def = CORBA::IDLType::_nil();
    (SeqStr[2]).name = (const char*) "aUShort";
    (SeqStr[2]).type = CORBA::TypeCode::_duplicate(CORBA::_tc_ushort);
    (SeqStr[2]).type_def = CORBA::IDLType::_nil();

    CORBA::TypeCode_var bTC = orb->create_struct_tc("IDL:aStruct:1.0","aStruct",SeqStr);

    CORBA::TypeCode_var bTC_copy = CORBA::TypeCode::_duplicate(bTC);
    cout << "Created TypeCodes: " << endl;;
    cout << "\naTC: ";
    typecodeParse::parseCode(aTC);
    cout << endl;

    cout << "\nbTC: ";
    typecodeParse::parseCode(bTC);
    cout << endl;
    
    CORBA::TypeCode_var rcTC;
    CORBA::TypeCode_var cTC;
    cout << "\nInvoking method." << endl;
    rcTC = tObj->testOp(aTC,bTC,cTC);

    cout << "\nTypecode values:" << endl;

    cout << "\nbTC: ";
    typecodeParse::parseCode(bTC);
    cout << endl;

    cout << "\nReturn value: ";
    typecodeParse::parseCode(rcTC);
    cout << endl;

    cout << "\ncTC: ";
    typecodeParse::parseCode(cTC);
    cout << "\n" << endl;

    cout << "\n\nEquality tests: " << endl;

    if (!(aTC_copy->equal(aTC)))
      {
	cerr << "aTC test failed" << endl;
	return -1;
      }
    else
      {
	cout << "aTC test passed" << endl;
      }

    if (!(bTC_copy->equal(bTC)))
      {
	cerr << "bTC test failed" << endl;
	return -1;
      }
    else
      {
	cout << "bTC test passed" << endl;
      }

    if (!(cTC->equal(CORBA::_tc_double)))
      {
	cerr << "cTC test failed" << endl;
	return -1;
      }
    else
      {
	cout << "cTC test passed" << endl;
      }
    

    if (!(rcTC->equal(aTC_copy)))
      {
	cerr << "rcTC test failed" << endl;
	return -1;
      }
    else
      {
	cout << "rcTC test passed" << endl;
      }
    
    if (bTC->equal(aTC))
      {
	cerr << "Negative test failed" << endl;
	return -1;
      }
    else
      {
	cout << "Negative test passed" << endl;
      }


    cout << "Test passed." << endl;
    cout << "Finished!" << endl;

    return 1;
}
