// tcServer.cc
//

#include <iostream.h>


#include <common/common.h>

#include "typecodeParse.h"

#include "typecodeTest_i.h"


int main(int argc, char* argv[])
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name use_name;
  
  if (argc > 1) {
    if (argc != 2) {
      cerr << "Usage: tcServer [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	   << endl;
    }
    try {
	use_name = string_to_name(argv[1]);
    }
    catch (...) {
      cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
      return 1;
    }
  }

  typecodeTest_i* origObj = new typecodeTest_i();
  origObj->_obj_is_ready(boa);

  {
    typecodeTest_var myobj = origObj->_this();
    
    if (use_name.length()) {
      if (!bindObjectToName(orb,myobj,use_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobj);
	cerr << (char*)p << endl;
    }
  }

   boa->impl_is_ready();
   return 1;
}
