MODULE C [INTERFACE "C"];

IMPORT
  SYSTEM;
  
(*
These types are intended to be equivalent to their C counterparts.
They may vary depending on your system, but as long as you stick to a 32 Bit
Unix they should be fairly safe.
*)  

TYPE
  char* = CHAR;
  signedchar* = SHORTINT;                (* signed char *)
  shortint* = INTEGER;                   (* short int *)
  int* = LONGINT;
  longint* = LONGINT;                    (* long int *)
  address* = SYSTEM.ADDRESS;
  float* = REAL;
  double* = LONGREAL;

  enum1* = int;
  enum2* = int;
  enum4* = int;
  
  (* if your C compiler uses short enumerations, you'll have to replace the
     declarations above with
  enum1* = SHORTINT;
  enum2* = INTEGER;
  enum4* = LONGINT;
  *)
  
  FILE* = address;  (* this is acually a replacement for `FILE*', i.e., for a pointer type *)
  size_t* = int;
  uid_t* = int;
  gid_t* = int;


TYPE  (* some commonly used C array types *)
  charPtr1d* = POINTER TO ARRAY OF char;
  charPtr2d* = POINTER TO ARRAY OF charPtr1d;
  intPtr1d* = POINTER TO ARRAY OF int;

TYPE
  Proc* = PROCEDURE;
  
END C.
