/*	$Id: __libc.h,v 1.3 1997/09/26 07:49:08 acken Exp $	*/
/* make sure that __config.h has been included before this file! */
#ifdef __cplusplus
  extern "C" {
#endif

typedef LOCAL_SIZE_T size_t;

/* --- prototypes of libc functions called by the emitted code: */
extern void* malloc(size_t n);
extern void free(void *ptr);
#ifdef __GNUC__
/* somehow gcc 2.7.2 on SunOS 4 doesn't like the size_t type defined above and
   complains about a declaration conflict with its builtin memcpy; but with 
   gcc there is always a tricky and non-standard way around this problem: */
extern void* memcpy(void* dest, const void* src, __typeof__(sizeof(int)) n);
#else
extern void* memcpy(void* dest, const void* src, size_t n);
#endif
extern void* memset(void* block, int c, size_t n);
extern int strcmp(const char* s1, const char* s2);

#ifdef __cplusplus
  }  /* end of extern "C" */
#endif

#include "__mini_gc.h"
