#include "orbit-c-backend.h"
#include <glib.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
  FILE *of;
  IDL_ns ns;
  IDL_tree tree;
  gboolean had_default;
} CBECommonInfo;

static void orbit_cbe_common_process_piece(CBECommonInfo *cmi);
static void cbe_common_do_attr_dcl(CBECommonInfo *cmi);
static void cbe_common_do_binop(CBECommonInfo *cmi);
static void cbe_common_do_boolean(CBECommonInfo *cmi);
static void cbe_common_do_case_stmt(CBECommonInfo *cmi);
static void cbe_common_do_char(CBECommonInfo *cmi);
static void cbe_common_do_const_dcl(CBECommonInfo *cmi);
static void cbe_common_do_except_dcl(CBECommonInfo *cmi);
static void cbe_common_do_fixed(CBECommonInfo *cmi);
static void cbe_common_do_float(CBECommonInfo *cmi);
static void cbe_common_do_forward_dcl(CBECommonInfo *cmi);
static void cbe_common_do_gentree(CBECommonInfo *cmi);
static void cbe_common_do_ident(CBECommonInfo *cmi);
static void cbe_common_do_integer(CBECommonInfo *cmi);
static void cbe_common_do_interface(CBECommonInfo *cmi);
static void cbe_common_do_list(CBECommonInfo *cmi);
static void cbe_common_do_member(CBECommonInfo *cmi);
static void cbe_common_do_module(CBECommonInfo *cmi);
static void cbe_common_do_none(CBECommonInfo *cmi);
static void cbe_common_do_op_dcl(CBECommonInfo *cmi);
static void cbe_common_do_param_dcl(CBECommonInfo *cmi);
static void cbe_common_do_string(CBECommonInfo *cmi);
static void cbe_common_do_type_any(CBECommonInfo *cmi);
static void cbe_common_do_type_array(CBECommonInfo *cmi);
static void cbe_common_do_type_boolean(CBECommonInfo *cmi);
static void cbe_common_do_type_char(CBECommonInfo *cmi);
static void cbe_common_do_type_dcl(CBECommonInfo *cmi);
static void cbe_common_do_type_enum(CBECommonInfo *cmi);
static void cbe_common_do_type_fixed(CBECommonInfo *cmi);
static void cbe_common_do_type_float(CBECommonInfo *cmi);
static void cbe_common_do_type_integer(CBECommonInfo *cmi);
static void cbe_common_do_type_object(CBECommonInfo *cmi);
static void cbe_common_do_type_octet(CBECommonInfo *cmi);
static void cbe_common_do_type_sequence(CBECommonInfo *cmi);
static void cbe_common_do_type_string(CBECommonInfo *cmi);
static void cbe_common_do_type_union(CBECommonInfo *cmi);
static void cbe_common_do_type_struct(CBECommonInfo *cmi);
static void cbe_common_do_type_wide_char(CBECommonInfo *cmi);
static void cbe_common_do_type_wide_string(CBECommonInfo *cmi);
static void cbe_common_do_unaryop(CBECommonInfo *cmi);
static void cbe_common_do_wide_char(CBECommonInfo *cmi);
static void cbe_common_do_wide_string(CBECommonInfo *cmi);

static void cbe_common_process_union_piece(CBECommonInfo* cmi);

void
orbit_cbe_write_common(FILE *outfile, IDL_ns ns, IDL_tree tree,
		       const char *header_filename)
{
  CBECommonInfo cmi = {outfile, ns, tree};

  fprintf(outfile, "/*\n"
  		   " * This file was generated by orbit-idl - DO NOT EDIT!\n"
		   " */\n\n");
  fprintf(outfile, "#include \"%s\"\n", header_filename);
  fprintf(outfile, "#define GET_ATOM(x) ({ GIOP_RECV_BUFFER(_ORBIT_recv_buffer)->decoder(&x, (GIOP_RECV_BUFFER(_ORBIT_recv_buffer)->cur), sizeof(x)); GIOP_RECV_BUFFER(_ORBIT_recv_buffer)->cur += sizeof(x); })\n\n");

  orbit_cbe_common_process_piece(&cmi);
}

static void
orbit_cbe_common_process_piece(CBECommonInfo *cmi)
{
  switch(IDL_NODE_TYPE(cmi->tree)) {
  case IDLN_ATTR_DCL:
    cbe_common_do_attr_dcl(cmi);
    break;
  case IDLN_BINOP:
    cbe_common_do_binop(cmi);
    break;
  case IDLN_BOOLEAN:
    cbe_common_do_boolean(cmi);
    break;
  case IDLN_CASE_STMT:
    cbe_common_do_case_stmt(cmi);
    break;
  case IDLN_CHAR:
    cbe_common_do_char(cmi);
    break;
  case IDLN_CONST_DCL:
    cbe_common_do_const_dcl(cmi);
    break;
  case IDLN_EXCEPT_DCL:
    cbe_common_do_except_dcl(cmi);
    break;
  case IDLN_FIXED:
    cbe_common_do_fixed(cmi);
    break;
  case IDLN_FLOAT:
    cbe_common_do_float(cmi);
    break;
  case IDLN_FORWARD_DCL:
    cbe_common_do_forward_dcl(cmi);
    break;
  case IDLN_GENTREE:
    cbe_common_do_gentree(cmi);
    break;
  case IDLN_IDENT:
    cbe_common_do_ident(cmi);
    break;
  case IDLN_INTEGER:
    cbe_common_do_integer(cmi);
    break;
  case IDLN_INTERFACE:
    cbe_common_do_interface(cmi);
    break;
  case IDLN_LIST:
    cbe_common_do_list(cmi);
    break;
  case IDLN_MEMBER:
    cbe_common_do_member(cmi);
    break;
  case IDLN_MODULE:
    cbe_common_do_module(cmi);
    break;
  case IDLN_NONE:
    cbe_common_do_none(cmi);
    break;
  case IDLN_OP_DCL:
    cbe_common_do_op_dcl(cmi);
    break;
  case IDLN_PARAM_DCL:
    cbe_common_do_param_dcl(cmi);
    break;
  case IDLN_STRING:
    cbe_common_do_string(cmi);
    break;
  case IDLN_TYPE_ANY:
    cbe_common_do_type_any(cmi);
    break;
  case IDLN_TYPE_ARRAY:
    cbe_common_do_type_array(cmi);
    break;
  case IDLN_TYPE_BOOLEAN:
    cbe_common_do_type_boolean(cmi);
    break;
  case IDLN_TYPE_CHAR:
    cbe_common_do_type_char(cmi);
    break;
  case IDLN_TYPE_DCL:
    cbe_common_do_type_dcl(cmi);
    break;
  case IDLN_TYPE_FIXED:
    cbe_common_do_type_fixed(cmi);
    break;
  case IDLN_TYPE_FLOAT:
    cbe_common_do_type_float(cmi);
    break;
  case IDLN_TYPE_INTEGER:
    cbe_common_do_type_integer(cmi);
    break;
  case IDLN_TYPE_OBJECT:
    cbe_common_do_type_object(cmi);
    break;
  case IDLN_TYPE_OCTET:
    cbe_common_do_type_octet(cmi);
    break;
  case IDLN_TYPE_SEQUENCE:
    cbe_common_do_type_sequence(cmi);
    break;
  case IDLN_TYPE_STRING:
    cbe_common_do_type_string(cmi);
    break;
  case IDLN_TYPE_STRUCT:
    cbe_common_do_type_struct(cmi);
    break;
  case IDLN_TYPE_UNION:
    cbe_common_do_type_union(cmi);
    break;
  case IDLN_TYPE_WIDE_CHAR:
    cbe_common_do_type_wide_char(cmi);
    break;
  case IDLN_TYPE_WIDE_STRING:
    cbe_common_do_type_wide_string(cmi);
    break;
  case IDLN_UNARYOP:
    cbe_common_do_unaryop(cmi);
    break;
  case IDLN_WIDE_CHAR:
    cbe_common_do_wide_char(cmi);
    break;
  case IDLN_WIDE_STRING:
    cbe_common_do_wide_string(cmi);
    break;
  case IDLN_TYPE_ENUM:
    cbe_common_do_type_enum(cmi);
    break;
  case IDLN_NATIVE:
    break;
  default:
    g_error("%s not handled in common",
	    IDL_tree_type_names[IDL_NODE_TYPE(cmi->tree)]);
    break;
  }
}

static void
cbe_common_do_attr_dcl(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  /* g_assert(!"Not yet implemented"); */
}

static void
cbe_common_do_binop(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  /* g_assert(!"Not yet implemented"); */
}

static void
cbe_common_do_boolean(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  /* g_assert(!"Not yet implemented"); */
}

static void
cbe_common_do_case_stmt(CBECommonInfo *cmi)
{
  /* does the __free() routine pieces for cbe_common_do_union() */
  IDL_tree curitem;
  CBECommonInfo child_cmi = *cmi;
  gboolean is_fixed;

  child_cmi.tree = IDL_CASE_STMT(cmi->tree).element_spec;

  for(curitem = IDL_CASE_STMT(cmi->tree).labels;
      curitem;
      curitem = IDL_LIST(curitem).next) {
    if(IDL_LIST(curitem).data) {
      fprintf(cmi->of, "  case ");
      orbit_cbe_write_const(cmi->of, IDL_LIST(curitem).data);
      fprintf(cmi->of, ":\n");
    } else {
      fprintf(cmi->of, "  default:\n");
      cmi->had_default = TRUE;
    }
  }
  
  is_fixed = cbe_type_is_fixed_length(IDL_MEMBER(child_cmi.tree).type_spec);
  if(!is_fixed) {
#if 0
    fprintf(cmi->of, "    extern gpointer ");
    orbit_cbe_write_typename(cmi->of, IDL_MEMBER(child_cmi.tree).type_spec);
    fprintf(cmi->of, "__free(gpointer mem);\n");
#endif
    
    orbit_cbe_write_typename(cmi->of, IDL_MEMBER(child_cmi.tree).type_spec);
    fprintf(cmi->of, "__free(&(var->_u.%s), NULL, free_strings);\n",
	    IDL_IDENT(IDL_LIST(IDL_MEMBER(child_cmi.tree).dcls).data).str);
  }

  fprintf(cmi->of, "    break;\n");
}

static void
cbe_common_do_char(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_const_dcl(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  /* g_assert(!"Not yet implemented"); */
}

static void
cbe_common_do_except_dcl(CBECommonInfo *cmi)
{
  CBEDemarshalInfo dmi;
  char *id;
  GString *tmpstr = g_string_new(NULL);

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_EXCEPT_DCL(cmi->tree).ident),
			       "_", 0);

  fprintf(cmi->of, "void %s_demarshal(GIOPRecvBuffer *_ORBIT_recv_buffer, CORBA_Environment *ev)\n", id);

  fprintf(cmi->of, "{\n");

  fprintf(cmi->of, "  CORBA_free(ev->_any);\n");

  fprintf(cmi->of, "  ev->_any = CORBA_any_alloc();\n");
  fprintf(cmi->of, "  ev->_any->_type = (CORBA_TypeCode)" );
  
  if (enable_typecodes)
      fprintf(cmi->of, "&TC_%s;\n", id);
  else
      fprintf(cmi->of, "NULL; /* Typecode disabled */\n" );

  fprintf(cmi->of, "  if(giop_msg_conversion_needed(GIOP_MESSAGE_BUFFER(_ORBIT_recv_buffer))) {\n");

  dmi.of = cmi->of;
  dmi.previous_param = NULL;
  dmi.param = dmi.typespec = cmi->tree;
  dmi.byteswap_version = TRUE;
  g_string_sprintf(tmpstr, "(*((%s *)ev->_any->_value))", id);
  dmi.param_name = tmpstr->str;
  dmi.orb_name = "GIOP_MESSAGE_BUFFER(_ORBIT_recv_buffer)->connection->orb_data";

  cbe_output_demarshaller(&dmi);

  fprintf(cmi->of, "  } else {\n");

  dmi.previous_param = NULL;
  dmi.byteswap_version = FALSE;

  cbe_output_demarshaller(&dmi);

  fprintf(cmi->of, "  }\n");

  fprintf(cmi->of, "}\n");

  cbe_common_do_type_struct(cmi);

  free(id);
  g_string_free(tmpstr, TRUE);
}

static void
cbe_common_do_fixed(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_float(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_forward_dcl(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  /* g_assert(!"Not yet implemented"); */
}

static void
cbe_common_do_gentree(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_ident(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_integer(CBECommonInfo *cmi)
{
  /* Nothing to do in common. */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_interface(CBECommonInfo *cmi)
{
  char *id;

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_INTERFACE(cmi->tree).ident),
			       "_", 0);

  fprintf(cmi->of, "CORBA_unsigned_long %s__classid = 0;\n\n", id);
  free(id);

  cmi->tree = IDL_INTERFACE(cmi->tree).body;
  cbe_common_do_list(cmi);
}

static void
cbe_common_do_list(CBECommonInfo *cmi)
{
  IDL_tree curitem;
  for(curitem = cmi->tree;
      curitem;
      curitem = IDL_LIST(curitem).next) {
    cmi->tree = IDL_LIST(curitem).data;
    orbit_cbe_common_process_piece(cmi);
  }
}

static void
cbe_common_do_member(CBECommonInfo *cmi)
{
  IDL_tree curitem, ts;

  if(cbe_type_is_fixed_length(IDL_MEMBER(cmi->tree).type_spec))
    return;

  ts = cbe_get_typespec(IDL_MEMBER(cmi->tree).type_spec);

  if(IDL_NODE_TYPE(ts) == IDLN_TYPE_STRING)
    fprintf(cmi->of, "if(free_strings) ");
  else
    fprintf(cmi->of, "\n");

  fprintf(cmi->of, "{\n");

#if 0
  ("extern gpointer ");
  orbit_cbe_write_typename(cmi->of, IDL_MEMBER(cmi->tree).type_spec);
  fprintf(cmi->of, "__free(gpointer mem, gpointer dat, CORBA_boolean free_strings);\n");
#endif

  for(curitem = IDL_MEMBER(cmi->tree).dcls;
      curitem; curitem = IDL_LIST(curitem).next) {
    fprintf(cmi->of, "  ");
    orbit_cbe_write_typename(cmi->of, IDL_MEMBER(cmi->tree).type_spec);
    fprintf(cmi->of, "__free(&var->%s, NULL, free_strings);\n",
	    IDL_IDENT(IDL_LIST(curitem).data).str);
  }
  fprintf(cmi->of, "}\n");
}

static void
cbe_common_do_module(CBECommonInfo *cmi)
{
  char *id;

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_MODULE(cmi->tree).ident), "_", 0);
  fprintf(cmi->of, "/***************** Begin module %s ***************/\n", id);

  cmi->tree = IDL_MODULE(cmi->tree).definition_list;
  orbit_cbe_common_process_piece(cmi);
  fprintf(cmi->of, "/***************** End module %s ***************/\n", id);
  free(id);
}

static void
cbe_common_do_none(CBECommonInfo *cmi)
{
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_op_dcl(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  /* g_assert(!"Not yet implemented"); */
}

static void
cbe_common_do_param_dcl(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_string(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_type_any(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_array(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_boolean(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_char(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}

static void
do_type_dcl_sequence(CBECommonInfo *cmi, IDL_tree ident)
{
  char *id;
  gboolean elements_are_fixed;

  elements_are_fixed = cbe_type_is_fixed_length(IDL_TYPE_SEQUENCE(cmi->tree).simple_type_spec);

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(ident), "_", 0);

  fprintf(cmi->of, "gpointer %s__free(gpointer mem, gpointer dat, CORBA_boolean free_strings)\n", id);
  fprintf(cmi->of, "{\n");
    
  fprintf(cmi->of, "  %s* val = mem;\n", id);
  fprintf(cmi->of, "  if(val->_release)");
  fprintf(cmi->of, "    ORBit_free(val->_buffer, free_strings);\n");
    
  fprintf(cmi->of, "  return mem + sizeof(%s);\n", id);
    
  fprintf(cmi->of, "}\n\n");

  /* The allocbuf function */
  fprintf(cmi->of, "#ifndef HAVE_ALLOCBUF_");
  orbit_cbe_write_typename(cmi->of, IDL_TYPE_DCL(cmi->tree).type_spec);
  fprintf(cmi->of, "\n");

  fprintf(cmi->of, "#define HAVE_ALLOCBUF_");
  orbit_cbe_write_typename(cmi->of, IDL_TYPE_DCL(cmi->tree).type_spec);
  fprintf(cmi->of, " 1\n");

  orbit_cbe_write_typespec(cmi->of, IDL_TYPE_DCL(cmi->tree).type_spec);
  fprintf(cmi->of, "* CORBA_sequence_");  
  orbit_cbe_write_typename(cmi->of, IDL_TYPE_DCL(cmi->tree).type_spec);
  fprintf(cmi->of, "_allocbuf(CORBA_unsigned_long len)\n");
  fprintf(cmi->of, "{\n  ");

  fprintf(cmi->of, "  return ORBit_alloc(sizeof(");
  orbit_cbe_write_typespec(cmi->of,
			   IDL_TYPE_SEQUENCE(cmi->tree).simple_type_spec);
  fprintf(cmi->of, ")*len, (ORBit_free_childvals)");

  if(elements_are_fixed) {
    fprintf(cmi->of, "NULL,");
  } else {
     orbit_cbe_write_typename(cmi->of,
			     IDL_TYPE_SEQUENCE(cmi->tree).simple_type_spec);
    fprintf(cmi->of, "__free,");
  }
  fprintf(cmi->of, " GUINT_TO_POINTER(len));\n");

  fprintf(cmi->of, "}\n");

  fprintf(cmi->of, "#endif\n\n");

  /* alloc function */
  fprintf(cmi->of, "%s* %s__alloc(void)\n", id, id);
  fprintf(cmi->of, "{\n  %s *retval;\n", id);
  fprintf(cmi->of,
	  "  retval = ORBit_alloc(sizeof(%s), (ORBit_free_childvals)%s__free, GUINT_TO_POINTER(1));\n", id, id);

    fprintf(cmi->of, "  retval->_maximum = ");
  if(IDL_TYPE_SEQUENCE(cmi->tree).positive_int_const) {
    orbit_cbe_write_const(cmi->of, IDL_TYPE_SEQUENCE(cmi->tree).positive_int_const);
    fprintf(cmi->of, ";\n");
  } else
    fprintf(cmi->of, "0;\n");

  fprintf(cmi->of, "  retval->_length = 0;\n");
  fprintf(cmi->of, "  retval->_release = CORBA_TRUE;\n");
  fprintf(cmi->of, "  retval->_buffer = NULL;\n");

  fprintf(cmi->of, "  return retval;\n}\n\n");

  free(id);
}

static void
do_type_dcl_array(CBECommonInfo *cmi, IDL_tree ident)
{
  char *id;
  IDL_tree curitem;
  IDL_tree dcl = IDL_get_parent_node(ident, IDLN_TYPE_DCL, NULL);
  int dimn;
  gboolean elements_are_fixed;

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_TYPE_ARRAY(ident).ident),
			       "_", 0);

  elements_are_fixed = cbe_type_is_fixed_length(IDL_TYPE_DCL(dcl).type_spec);

  if(!elements_are_fixed) {
    fprintf(cmi->of, "gpointer %s__free(gpointer mem)\n{\n", id);

    fprintf(cmi->of, "  int n0");

    for(dimn = 1, curitem = IDL_LIST(IDL_TYPE_ARRAY(ident).size_list).next;
	curitem; dimn++, curitem = IDL_LIST(curitem).next) {
      fprintf(cmi->of, ", n%d", dimn);
    }
    fprintf(cmi->of, ";\n");

    for(dimn = 0, curitem = IDL_TYPE_ARRAY(ident).size_list;
	curitem; dimn++, curitem = IDL_LIST(curitem).next) {
      fprintf(cmi->of, "  for(n%d = 0; n%d < %lld; n%d++) {\n",
	      dimn, dimn, IDL_INTEGER(IDL_LIST(curitem).data).value, dimn);
    }

#if 0
    fprintf(cmi->of, "  extern gpointer ");
    orbit_cbe_write_typename(cmi->of, IDL_TYPE_DCL(dcl).type_spec);
    fprintf(cmi->of, "__free(gpointer mem, gpointer dat, CORBA_boolean free_strings);\n");
#endif

    fprintf(cmi->of, "  ");
    orbit_cbe_write_typename(cmi->of, IDL_TYPE_DCL(dcl).type_spec);
    fprintf(cmi->of, "__free(((%s *)mem, NULL, free_strings)", id);
    for(dimn = 0, curitem = IDL_TYPE_ARRAY(ident).size_list;
	curitem; dimn++, curitem = IDL_LIST(curitem).next) {
      fprintf(cmi->of, "[n%d]", dimn);
    }
    fprintf(cmi->of, ");\n");

    for(dimn--, curitem = IDL_TYPE_ARRAY(ident).size_list;
	curitem; dimn--, curitem = IDL_LIST(curitem).next) {
      fprintf(cmi->of, "  } /* end loop for n%d */\n", dimn);
    }
    fprintf(cmi->of, "  return mem + sizeof(%s);\n", id);
    fprintf(cmi->of, "}\n");
  }

  fprintf(cmi->of, "%s_slice* %s__alloc(void)\n", id, id);
  fprintf(cmi->of, "{\n");

  fprintf(cmi->of, "  return ORBit_alloc(sizeof(%s), (ORBit_free_childvals)",
	  id);

  if(elements_are_fixed)
    fprintf(cmi->of, "NULL, NULL);\n");
  else {
    orbit_cbe_write_typename(cmi->of, IDL_TYPE_DCL(dcl).type_spec);
    curitem = IDL_TYPE_ARRAY(ident).size_list;
    fprintf(cmi->of, "__free, %lld", IDL_INTEGER(IDL_LIST(curitem).data).value);
    for(; curitem; curitem = IDL_LIST(curitem).next)
      fprintf(cmi->of, "*%lld", IDL_INTEGER(IDL_LIST(curitem).data).value);
    fprintf(cmi->of, ");\n");
  }

  fprintf(cmi->of, "}\n");

  free(id);
}

static void
cbe_common_do_type_dcl(CBECommonInfo *cmi)
{
  IDL_tree curitem;
  CBECommonInfo child_cmi = {cmi->of, cmi->ns, IDL_TYPE_DCL(cmi->tree).type_spec};

  for(curitem = IDL_TYPE_DCL(cmi->tree).dcls; curitem; curitem = IDL_LIST(curitem).next) {

    switch(IDL_NODE_TYPE(IDL_TYPE_DCL(cmi->tree).type_spec)) {
    case IDLN_TYPE_SEQUENCE:
      orbit_output_typecode(cmi->of, IDL_LIST(curitem).data);
      do_type_dcl_sequence(&child_cmi, IDL_LIST(curitem).data);
      break;
    case IDLN_TYPE_ARRAY:
    case IDLN_IDENT: /* Lame hack for arrays. Fixme. */
      if(IDL_NODE_TYPE(IDL_LIST(curitem).data) == IDLN_TYPE_ARRAY) {
	orbit_output_typecode(cmi->of, IDL_LIST(curitem).data);
	do_type_dcl_array(&child_cmi, IDL_LIST(curitem).data);
      } else {
#if 0
	fprintf(cmi->of, "typedef ");
	orbit_cbe_write_typespec(cmi->of, IDL_TYPE_DCL(cmi->tree).type_spec);
	fprintf(cmi->of, " ");
	orbit_cbe_write_typename(cmi->of, IDL_LIST(curitem).data);
	fprintf(cmi->of, ";\n");
#endif
      }
      break;
    case IDLN_TYPE_INTEGER:
    case IDLN_TYPE_FLOAT:
    case IDLN_TYPE_CHAR:
    case IDLN_TYPE_WIDE_CHAR:
    case IDLN_TYPE_BOOLEAN:
    case IDLN_TYPE_OCTET:
    case IDLN_TYPE_STRING:
    case IDLN_TYPE_WIDE_STRING:
      orbit_output_typecode(cmi->of, IDL_LIST(curitem).data);
      break;
    default:
      g_warning("Unhandled type %s in TYPE_DCL",
		IDL_tree_type_names[IDL_NODE_TYPE(IDL_TYPE_DCL(cmi->tree).type_spec)]);
    }
  }
}

static void
cbe_common_do_type_enum(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_fixed(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_float(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_integer(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_object(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_octet(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_sequence(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_type_string(CBECommonInfo *cmi)
{
  orbit_output_typecode(cmi->of, cmi->tree);
}

static void
cbe_common_do_union_case_stmt(CBECommonInfo* cmi)
{
  IDL_tree curitem;
  CBECommonInfo sub_cmi = *cmi;
  
  sub_cmi.tree = IDL_CASE_STMT(cmi->tree).element_spec;
  for (curitem = IDL_CASE_STMT(cmi->tree).labels; curitem; curitem = IDL_LIST(curitem).next)
    {
      if (IDL_LIST(curitem).data)
	{
	  fprintf(cmi->of, "case " );
	  orbit_cbe_write_const(cmi->of, IDL_LIST(curitem).data);
	  fprintf(cmi->of,":\n");
	}
      else
	{
	  cmi->had_default = 1;
	  fprintf(cmi->of, "default: ");
	}
    }
  cbe_common_process_union_piece(&sub_cmi);
  fprintf(cmi->of, "break;\n");
}

static void
cbe_common_do_union_member(CBECommonInfo* cmi)
{
  IDL_tree curitem, li, sz;
  IDL_tree ts;
  
  for (curitem = IDL_MEMBER(cmi->tree).dcls; curitem; curitem = IDL_LIST(curitem).next)
    {
      li = IDL_MEMBER(cmi->tree).type_spec;
      ts = cbe_get_typespec(curitem);
      
      if(cbe_type_is_fixed_length(ts))
	{
	  fprintf(cmi->of,"/* Fixed length member, doing nothing */\n"); 
	  continue;
	}
      else
	{
	  if (IDL_NODE_TYPE(ts) == IDLN_TYPE_STRING)
	    {
	      fprintf(cmi->of, "if (free_strings) {\n");
	    }
	  else
	    {
	      fprintf(cmi->of, "{\n");
	    }
	  orbit_cbe_write_typename(cmi->of, li); /* ts); */
	  fprintf(cmi->of, "__free(&var->_u.%s, NULL, free_strings);\n",
		  IDL_IDENT(IDL_LIST(curitem).data).str);
	  fprintf(cmi->of, "}\n");
	}
    }
}

static void
cbe_common_process_union_piece(CBECommonInfo* cmi)
{
  IDL_tree curmem = cmi->tree;
  
  switch (IDL_NODE_TYPE(curmem))
    {
    case IDLN_CASE_STMT:
      cbe_common_do_union_case_stmt(cmi);
      break;
    case IDLN_MEMBER:
      cbe_common_do_union_member(cmi);
      break;
    default:
      fprintf(stderr,"orbit_cbe_common_process_union_piece: unhandled type %s\n",  IDL_NODE_TYPE_NAME(curmem));
    }
}


static void
cbe_common_do_type_union(CBECommonInfo *cmi)
{
  char *id;
  gboolean elements_are_fixed = cbe_type_is_fixed_length(cmi->tree);
  IDL_tree curitem, curelem, curmem, curdcl, ts;
  CBECommonInfo subcmi = *cmi;
  
  subcmi.had_default = FALSE;

  orbit_output_typecode(cmi->of, cmi->tree);

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_TYPE_UNION(cmi->tree).ident),
			       "_", 0);

  if(!elements_are_fixed) {
    fprintf(cmi->of, "gpointer %s__free(gpointer mem, gpointer dat, CORBA_boolean free_strings)\n", id);
    fprintf(cmi->of, "{\n");
    fprintf(cmi->of, "  ");
    orbit_cbe_write_typespec(cmi->of, cmi->tree);
    fprintf(cmi->of, " *var = mem;");

    fprintf(cmi->of, "  switch(var->_d) {\n");
    for(curitem = IDL_TYPE_UNION(cmi->tree).switch_body; curitem; curitem = IDL_LIST(curitem).next) {
      subcmi.tree = IDL_LIST(curitem).data;
      cbe_common_process_union_piece(&subcmi);
    }
    if(!subcmi.had_default) /* Eliminate gcc warnings */
      fprintf(cmi->of, "default:\n");
    fprintf(cmi->of, "  }\n");

    fprintf(cmi->of, "  return mem + sizeof(%s);\n", id);
    fprintf(cmi->of, "}\n");
  }

  orbit_cbe_write_typespec(cmi->of, cmi->tree);
  fprintf(cmi->of, "* %s__alloc(void)\n", id);
  fprintf(cmi->of, "{\n  return ORBit_alloc(sizeof(%s), (ORBit_free_childvals)", id);
  if(!elements_are_fixed)
    fprintf(cmi->of, "%s__free, ", id);
  else
    fprintf(cmi->of, "NULL, ");
  fprintf(cmi->of, "GUINT_TO_POINTER(1));\n}\n\n");

  free(id);
}

static void
cbe_common_do_type_struct(CBECommonInfo *cmi)
{
  char *id;
  gboolean elements_are_fixed =  cbe_type_is_fixed_length(cmi->tree);
  IDL_tree curitem, curmem, curdcl, ts;

  orbit_output_typecode(cmi->of, cmi->tree);

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_TYPE_STRUCT(cmi->tree).ident),
			       "_", 0);

  if(!elements_are_fixed) {
    fprintf(cmi->of, "gpointer %s__free(gpointer mem, gpointer dat, CORBA_boolean free_strings)\n", id);
    fprintf(cmi->of, "{\n");
    fprintf(cmi->of, "  ");
    orbit_cbe_write_typespec(cmi->of, cmi->tree);
    fprintf(cmi->of, " *var = mem;");

    for(curitem = IDL_TYPE_STRUCT(cmi->tree).member_list;
	curitem; curitem = IDL_LIST(curitem).next) {
      curmem = IDL_LIST(curitem).data;

      if(cbe_type_is_fixed_length(IDL_MEMBER(curmem).type_spec))
	continue;

      ts = cbe_get_typespec(IDL_MEMBER(curmem).type_spec);
      if(IDL_NODE_TYPE(ts) == IDLN_TYPE_STRING)
	fprintf(cmi->of, "if(free_strings) {\n");
      else
	fprintf(cmi->of, "{\n");

      for(curdcl = IDL_MEMBER(curmem).dcls; curdcl;
	  curdcl = IDL_LIST(curdcl).next) {
	orbit_cbe_write_typename(cmi->of, IDL_MEMBER(curmem).type_spec);
	fprintf(cmi->of, "__free(&var->%s, NULL, free_strings);\n",
		IDL_IDENT(IDL_LIST(curdcl).data).str);
      }
      fprintf(cmi->of, "}\n");
    }

    fprintf(cmi->of, "  return mem + sizeof(");
    orbit_cbe_write_typespec(cmi->of, cmi->tree);
    fprintf(cmi->of, ");\n}\n");
  }

  orbit_cbe_write_typespec(cmi->of, cmi->tree);
  fprintf(cmi->of, "* %s__alloc(void)\n", id);
  fprintf(cmi->of, "{\n  return ORBit_alloc(sizeof(");
  orbit_cbe_write_typespec(cmi->of, cmi->tree);
  fprintf(cmi->of, "), (ORBit_free_childvals)");
  if(!elements_are_fixed)
    fprintf(cmi->of, "%s__free, ", id);
  else
    fprintf(cmi->of, "NULL, ");
  fprintf(cmi->of, "GUINT_TO_POINTER(1));\n}\n\n");

  free(id);
}

static void
cbe_common_do_type_wide_char(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_type_wide_string(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_unaryop(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_wide_char(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}

static void
cbe_common_do_wide_string(CBECommonInfo *cmi)
{
  /* Nothing to handle in common */
  g_assert(!"Not yet implemented");
}
