/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#ifndef _ORBIT_CORBA_TYPECODE_H_
#define _ORBIT_CORBA_TYPECODE_H_

/* moved from orbit_types.h */
typedef struct CORBA_TypeCode_struct *CORBA_TypeCode;

typedef enum {
	CORBA_tk_null=0,
	CORBA_tk_void=1,
	CORBA_tk_short=2,
	CORBA_tk_long=3,
	CORBA_tk_ushort=4,
	CORBA_tk_ulong=5,
	CORBA_tk_float=6,
	CORBA_tk_double=7,
	CORBA_tk_boolean=8,
	CORBA_tk_char=9,
	CORBA_tk_octet=10,
	CORBA_tk_any=11,
	CORBA_tk_TypeCode=12,
	CORBA_tk_Principal=13,
	CORBA_tk_objref=14,
 	CORBA_tk_struct=15,
	CORBA_tk_union=16,
	CORBA_tk_enum=17,
	CORBA_tk_string=18,
	CORBA_tk_sequence=19,
	CORBA_tk_array=20,
	CORBA_tk_alias=21,
	CORBA_tk_except=22,
	CORBA_tk_longlong=23,
	CORBA_tk_ulonglong=24,
	CORBA_tk_longdouble=25,
	CORBA_tk_wchar=26,
	CORBA_tk_wstring=27,
	CORBA_tk_fixed=28,
	CORBA_tk_recursive=0xffffffff,
	CORBA_tk_last=29	/* hack for GIOP */
} CORBA_TCKind;


/* moved from typecode.h */
#define TC_CORBA_short TC_short
#define TC_CORBA_long TC_long
#define TC_CORBA_longlong TC_longlong
#define TC_CORBA_ushort TC_ushort
#define TC_CORBA_ulong TC_ulong
#define TC_CORBA_ulonglong TC_ulonglong
#define TC_CORBA_float TC_float
#define TC_CORBA_double TC_double
#define TC_CORBA_longdouble TC_longdouble
#define TC_CORBA_boolean TC_boolean
#define TC_CORBA_char TC_char
#define TC_CORBA_wchar TC_wchar
#define TC_CORBA_octet TC_octet
#define TC_CORBA_any TC_any
#define TC_CORBA_TypeCode TC_TypeCode
#define TC_CORBA_Principal TC_Principal
#define TC_CORBA_Object TC_Object
#define TC_CORBA_string TC_string
#define TC_CORBA_wstring TC_wstring

extern struct CORBA_TypeCode_struct TC_null;
extern struct CORBA_TypeCode_struct TC_void;
extern struct CORBA_TypeCode_struct TC_short;
extern struct CORBA_TypeCode_struct TC_long;
extern struct CORBA_TypeCode_struct TC_longlong;
extern struct CORBA_TypeCode_struct TC_ushort;
extern struct CORBA_TypeCode_struct TC_ulong;
extern struct CORBA_TypeCode_struct TC_ulonglong;
extern struct CORBA_TypeCode_struct TC_float;
extern struct CORBA_TypeCode_struct TC_double;
extern struct CORBA_TypeCode_struct TC_longdouble;
extern struct CORBA_TypeCode_struct TC_boolean;
extern struct CORBA_TypeCode_struct TC_char;
extern struct CORBA_TypeCode_struct TC_wchar;
extern struct CORBA_TypeCode_struct TC_octet;
extern struct CORBA_TypeCode_struct TC_any;
extern struct CORBA_TypeCode_struct TC_TypeCode;
extern struct CORBA_TypeCode_struct TC_Principal;
extern struct CORBA_TypeCode_struct TC_Object;
extern struct CORBA_TypeCode_struct TC_string;
extern struct CORBA_TypeCode_struct TC_wstring;
extern struct CORBA_TypeCode_struct TC_CORBA_NamedValue;
extern struct CORBA_TypeCode_struct TC_CORBA_InterfaceDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_OperationDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_AttributeDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_ParameterDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_ModuleDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_ConstantDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_ExceptionDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_TypeDescription;
extern struct CORBA_TypeCode_struct TC_CORBA_InterfaceDef_FullInterfaceDescription;


#endif /* !_ORBIT_CORBA_TYPECODE_H_ */




