/*
 * PDATST.C - Test attribute features of PDB
 *
 * Source Version: 9.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pdb.h"

static int
 SC_DECLARE(print_info,
         (PDBfile *file, FILE *fp, HASHTAB *tab, char *s, char *var));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

int main()
   {PDBfile *file;
    FILE *fp;
    float d[10];
    int i, err, *rank, *center, **pc;
    HASHTAB *tab;

    SC_zero_space(0);
    err = TRUE;

    file = PD_open("pdatst.db", "w");
    fp   = fopen("pdatst.rs", "w");
    if ((file == NULL) || (fp == NULL))
       {PRINT(stderr, "Error creating pdatst.db\n");
        err = FALSE;
        return(err);};
    PRINT(fp, "\nCreated pdatst.db\n\n");

/* write out one variable */
    for (i = 0; i < 10; i++)
        d[i] = (float) i;

    PD_write(file, "d(10)", "float", d);

/* define & set some attributes */
    if (PD_def_attribute(file, "rank", "integer") == FALSE)
       {PRINT(fp, "Error defining RANK\n");
        err = FALSE;};

    if (PD_def_attribute(file, "centering", "integer *") == FALSE)
       {PRINT(fp, "Error defining CENTERING\n");
        err = FALSE;};

    rank  = FMAKE(int, "PDATST.C:rank");
    *rank = 1;

    pc  = FMAKE(int *, "PDATST.C:pc");
    *pc = center = FMAKE_N (int, 2, "PDATST.C:*pc");
    center[0] = 44;
    center[1] = 55;

    if (PD_set_attribute(file, "d", "rank", (byte *) rank) == FALSE)
       {PRINT(fp, "Error setting rank attribute\n");
        err = FALSE;};

    if (PD_set_attribute(file, "d", "centering", (byte *) pc) == FALSE)
       {PRINT(fp, "Error setting center attribute\n");
        err = FALSE;};

    err &= print_info(file, fp, file->attrtab, "d", "Attribute Table");

    PD_close(file);
    SFREE(rank);
    SFREE(center);

    file = PD_open("pdatst.db", "a");
    PRINT(fp, "\nRe-opened pdatst.db\n\n");

    err &= print_info(file, fp, file->attrtab, "d", "Attribute Table");

/* try writing then reading hash table from file */
    if (!PD_write(file, "foo", "HASHTAB", file->attrtab))
       {PRINT(fp, "Error writing attribute hash table to file.\n");
        PRINT(fp, "PD_err = %s\n", PD_err);
        err = FALSE;};

    tab = FMAKE(HASHTAB, "PDATST.C:tab");

    if (PD_read(file, "foo", tab) == FALSE)
       {PRINT(fp, "Error reading attribute hash table from file.\n");
        PRINT(fp, "PD_err = %s\n", PD_err);
        err = FALSE;};

    err &= print_info(file, fp, tab, "d", "foo");

/* close file */
    PD_close(file);

    return(!err);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PRINT_INFO - print attribute table info */

static int print_info(file, fp, tab, s, var)
   PDBfile *file;
   FILE *fp;
   HASHTAB *tab;
   char *s, *var;
   {char **names;
    int i, ret, *nrank, **center;

    ret = TRUE;

    PRINT(fp, "-------------------------------------------------------\n\n");

    PRINT(fp, "Variable: %s\n", var);

/* print contents of attribute table */
    names = SC_hash_dump(tab, NULL);
    for (i = 0; i < tab->nelements; i++)
        PRINT(fp, "\t%s\n", names[i]);

    SFREE(names);
    PRINT(fp, "\n");

/* get attribute associated with var */
    nrank = (int *) PD_get_attribute(file, s, "rank");
    if (nrank == NULL)
       {PRINT(fp, "Error getting rank attribute\n");
        ret = FALSE;}
    else
       PRINT(fp, "Rank of %s : %d\n", s, *nrank);

    center = (int **) PD_get_attribute(file, s, "centering");
    if (center == NULL)
       {PRINT(fp, "Error getting centering attribute\n");
        ret = FALSE;}
    else
       PRINT(fp, "Centering of %s : %d %d\n", s, center[0][0], center[0][1]);

    PRINT(fp, "\n-------------------------------------------------------\n");

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
