/*
 * TRNACF.H - the NACF support header for TRANSL
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#ifndef PCK_NACF

#include "cpyright.h"
 
#include "../../sx.h"
#include "../trconfig.h"

#define PCK_NACF

#ifdef HAVE_NACF

#include "../../sxtrans.h"

/*--------------------------------------------------------------------------*/

/*                              DEFINED CONSTANTS                           */

/*--------------------------------------------------------------------------*/

#define BMAXNAME   128      /* Max number of chars in a name */
#define BMAXCHILD  1024     /* Max number of children in a directory */

/* NACF data types */

#define NAC_FWFP     0
#define NAC_HWFP1    1
#define NAC_HWFP2    2
#define NAC_DWFP     3      /* not to be supported ever */
#define NAC_CFP      4      /* maybe someday */
#define NAC_FWSI     8
#define NAC_HWUI     9
#define NAC_QWUI    10
#define NAC_FWUI    11
#define NAC_BIT     16
#define NAC_BYTE    17
#define NAC_CHARS   18
#define NAC_ASCII   24
#define NAC_LJBF    25
#define NAC_REC     32

/*--------------------------------------------------------------------------*/

/*                          TYPEDEFS AND STRUCTS                            */

/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/

/*                          VARIABLE DECLARATIONS                           */

/*--------------------------------------------------------------------------*/

extern char
 *TR_NACFILE_S;

/*--------------------------------------------------------------------------*/

/*                          FUNCTION DECLARATIONS                           */

/*--------------------------------------------------------------------------*/


/* TRNACA.C declarations */

extern object
 SC_DECLARE(*TR_create_nacf, (object *arg)),
 SC_DECLARE(*TR_open_nacf, (object *arg)),
 SC_DECLARE(*TR_close_nacf, (object *arg)),
 SC_DECLARE(*TR_cd_nacf, (object *argl)),
 SC_DECLARE(*TR_make_nacdata, (object *argl)),
 SC_DECLARE(*TR_get_nacfile, (object *argl,
                            PDBfile **pfile)),
 SC_DECLARE(*TR_show_nacf, (object *argl)),
 SC_DECLARE(*TR_type_nacf, (object *argl)),
 SC_DECLARE(*TR_list_nacfvars, (object *argl)),
 SC_DECLARE(*TR_list_nacftypes, (object *argl)),
 SC_DECLARE(*TR_desc_nacfvar, (object *argl)),
 SC_DECLARE(*TR_help_nacf, (byte)),
 SC_DECLARE(*TR_pwd_nacf, (byte)),
 SC_DECLARE(*TR_mapping_nacf, (object *arg)),
 SC_DECLARE(*TR_nacf_mapping, (object *arg));

extern int
 SC_DECLARE(TR_nacfilep, (object *obj));

extern void
 SC_DECLARE(NAC_show, (int dbid, int id)),
 SC_DECLARE(NAC_type, (int dbid, int id)),
 SC_DECLARE(NAC_help, (byte)),
 SC_DECLARE(_NAC_print,
         (char *name, int id, char *values,
          int type, int nels, int lenel));

/* TRNACB.C declarations */

extern PDBfile
 SC_DECLARE(*NAC_open, (char *name, char *mode));

extern int
 SC_DECLARE(NAC_close, (PDBfile *file));

#endif

#endif

