#include <stdio.h>
#include <ctype.h>
#include "set.h"
#include "syn.h"
#include "hash.h"
#include "generic.h"

#ifdef __STDC__
void dumpruleset(set s)
#else
void dumpruleset(s)
  set   s;
#endif
{
    unsigned    *cursor;
    unsigned    *origin=set_pdq(s);

    require(origin != NULL,"set_pdq failed");

    if (RulePtr == NULL) {
      fprintf(stderr,"RulePtr[] not yet initialized");
    } else {
      for (cursor=origin; *cursor != nil ; cursor++) {
/****   if (cursor != origin) fprintf(stderr,","); ****/
        fprintf(stderr,"    %s",RulePtr[*cursor]->rname);
        fprintf(stderr,"\n");
      };
      free( (char *) origin);
    };
}


#ifdef __cplusplus
#ifndef __STDC__
#define __STDC__
#endif
#endif

void dumpcycles() {

  ListNode      *q;
  Cycle         *c;
  CacheEntry    *f;
  ListNode      *p;
  int           i=0;
  int           l;
  int           k;

  for (k=1; k <= CLL_k; k++) {
    if (Cycles[k] == NULL) continue;

    for (p = Cycles[k]->next; p!=NULL; p=p->next) {
  	  c = (Cycle *) p->elem;
	  fprintf(stderr,"Cycle %d: %s -->\n", i++, RulePtr[c->croot]->rname);
      fprintf(stderr,"    *self* ");
      dumpruleset(c->cyclicDep);
      fprintf(stderr,"\n");
	  f = (CacheEntry *)
			hash_get(Fcache,Fkey(RulePtr[c->croot]->rname,'o',k));
	  require(f!=NULL, eMsg1("FOLLOW(%s) must be in cache but isn't", RulePtr[c->croot]->rname) );
    };
  };
}
