#|------------------------------------------------------------*-Scheme-*--|
 | File:    handc/demo/calc/main.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:29
 | System build:     v0.7.2, 97.12.21
 |
 `------------------------------------------------------------------------|#

,(use zebu_run)
,(use repl)
,(use tables)

(define *calc-envt* (make-user-initial))

(load-into *calc-envt* "initial.scm")

;; take a list like   ((a <string>) b (#key x) y z (#rest p))
;; turn it into       ((a <string>) b #key x y z #rest p)

(define (flatten-args args)
  (apply append
	 (map (lambda (item)
		(if (pair? item)
		    (if (or (eq? (car item) '#key)
			    (eq? (car item) '#rest))
			item
			(list item))
		    (list item)))
	      args)))

(load-parse-tables "syntax.tab" *self*)

(define (main args)
  ;;
  ;; semicolons are no longer comments...
  ;;
  (vector-set! *scanners*
	       (char->integer #\;)
	       (lambda (port ch)
		 (values '<semicolon> #f (input-port-line-number port))))
  ;;
  ;;  and square-brackets are now valid
  ;;
  (vector-set! *scanners*
	       (char->integer #\[)
	       (lambda (port ch)
		 (values '<open-bracket> #f (input-port-line-number port))))
  (vector-set! *scanners*
	       (char->integer #\])
	       (lambda (port ch)
		 (values '<close-bracket> #f (input-port-line-number port))))

  ;;
  ;;  we need our own whitespace skipper because the standard
  ;;  one skips ;-comments too
  ;;
  (let ((skip-whitespace 
	 (lambda (p c)
	   (let loop ()
	     (let ((ch (input-port-read-char p)))
	       (if (eof-object? ch)
		   ch
		   (if (char-whitespace? ch)
		       (loop)
		       ((vector-ref *scanners* (char->integer ch)) p ch))))))))
    (for-each (lambda (ch)
		(vector-set! *scanners* (char->integer ch) skip-whitespace))
	      '(#\space #\tab #\newline)))
  ;;
  ;; arrange to catch signals
  ;;
  (fluid-let ((*signal-handler* (lambda args
				  (format $console-error-port
					  "caught signal... exiting\n~s\n" 
					  args)
				  (apply-backtrace #f)
				  (process-exit 1))))
    ;;
    (set-apply-trace-flag! #t)
    (display "calc, by Donovan Kolbly, using William Wells' Zebu parser generator\n")
    (display "(be sure to type `;' after your expression, like `1 + 3;')\n")
    (display "? ")
    (lr-parse scan-calc-token calc-error)))

(define (calc-error arg)
  (format $console-error-port "calculator error: ~a\n" arg)
  (process-exit 1))

