#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/corelib/process.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:39
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  corelib
 |
 | Purpose:          Standard this-process control functions
 `------------------------------------------------------------------------|#

;;;  
;;;  Baseline RScheme interface to the currently running process
;;;

(define *verbose* #t) ;; set to `#f' by start function if "-q" or "-script"

(define (set-verbose! f)
  (set! *verbose* f))

(define *args* '())  ;; application-level args (NOT process-level args)

(define (set-app-args! lst)
  (set! *args* lst))

(define-glue (process-abort)
{
unsigned i;

    for (i=0; i<arg_count_reg; i++)
      {
	fprintf( stderr, " process-abort[%u] := ", i );
	fprinto( stderr, reg_ref(i) );
	fprintf( stderr, "\n" );
      }
    abort();
})

(define-glue (process-exit code)
{
    if ((arg_count_reg != 1) || (!OBJ_ISA_FIXNUM(code)))
       abort();
    exit( fx2int(code) );
})

(define-glue (os-type)
{
   REG0 = os_type();
   RETURN1();
})

(define-glue (getenv str)
{
const char *r;

    COUNT_ARGS(1);
    if (STRING_P(str))
      {
	r = os_getenv( string_text(str) );
	REG0 = r ? make_string(r) : FALSE_OBJ;
      }
    else
        REG0 = FALSE_OBJ;
    RETURN1();
})

;; return the OS-level current working directory
;;
;; normal applications will only read this at startup
;; and not usually chdir around, although chdir'ing is
;; fine as long as you know what you're doing and you
;; update *current-dir* appropriately
;;
;; a minimal implementation can return "./", although
;; doing so (or returning any relative path) will make
;; dir-from-to signal an error if an attempt is made
;; to go from an absolute path to a relative path

(define-glue (os-getwd)
{
   REG0 = os_getwd();
   RETURN1();
})

(define-safe-glue (os-setwd! (path <raw-string>))
{
  os_setwd(path);
  RETURN0();
})

(define-glue (get-compile-options)
{
extern int bci_trace_flag;

  REG0 = (bci_trace_flag < 0) ? FALSE_OBJ : TRUE_OBJ;
#ifdef RECORD_CALL_CHAIN
  REG1 = TRUE_OBJ;
#else
  REG1 = FALSE_OBJ;
#endif
  RETURN(2);
})

;; check or set the bytecode interpreter's trace flag
;; returns the previous state of the trace flag
;;  the trace flag is not set unless `to' is exactly #t or #f

(define-glue (set-bci-trace-flag! to)
{
extern int bci_trace_flag;
int old;

 if (bci_trace_flag >= 0)
   {
     old = bci_trace_flag;

     if (EQ(to,TRUE_OBJ))
       bci_trace_flag = 1;
     else if (EQ(to,FALSE_OBJ))
       bci_trace_flag = 0;

     REG0 = rb_to_bo(old);
     RETURN1();
   }
  else
    {
      /* this should never happen, as nobody should call 
	 this function if get-compile-options indicates
	 that this functionality is not available 
	 */
      scheme_error( "strange call", 0 );
      RETURN0();
    }
})

(define-glue (set-apply-trace-flag! to)
{
#ifndef RECORD_CALL_CHAIN
  /* this should never happen, as nobody should call 
     this function if get-compile-options indicates
     that this functionality is not available 
     */
  scheme_error( "strange call", 0 );
  RETURN0();
#else
extern rs_bool do_record_call_chain;
rs_bool old;

  old = do_record_call_chain;
  if (EQ(to,TRUE_OBJ))
    do_record_call_chain = YES;
  else if (EQ(to,FALSE_OBJ))
    do_record_call_chain = NO;
  REG0 = rb_to_bo(old);
  RETURN1();
#endif
})

