,(use paths tables)

(define (death (err <condition>) next-handler)
  (display "--- internal error occurred\n" *console-error-port*)
  (display err *console-error-port*)
  (newline *console-error-port*)
  (process-exit 2))

(define (elim-dups lst)
  (let ((t (make-table string=? string->hash)))
    (let loop ((r '())
	       (l lst))
      (if (null? l)
	  (reverse r)
	  (if (table-lookup t (car l))
	      (loop r (cdr l))
	      (begin
		(table-insert! t (car l) #t)
		(loop (cons (car l) r) (cdr l))))))))

(define (main args)
  (format #t "inst => ~s\n" (getenv "INSTALL_DIR"))
  (handler-bind (<condition> death)
    (set! args (elim-dups args))
    (format #t "args => ~s\n" args)
    (let* ((dir (car args))
	   (name (last-directory (string->dir dir)))
	   (modules (cdr args))
	   (mx-data (map get-mx-data modules))
	   (pkg-data (apply append (map caddr mx-data)))
	   (pkg-o-dir (append-dirs (string->dir (getenv "INSTALL_DIR"))
				   (string->dir "lib")))
	   (error-cnt 0))
      (format #t "pkg-o-dir => ~a\n" pkg-o-dir)
      ;;
      ;; make sure the necessary pkg.o's are present
      ;;
      (for-each
       (lambda (pkg)
	 (format #t "pkg... ~s\n" pkg)
	 (if (not (file-exists? (append-path
				 pkg-o-dir
				 (string->file (format #f "~a.o" pkg)))))
	     (begin
	       (format *console-error-port*
		       "package `~a' not installed; use rsc to generate it\n"
		       pkg)
	       (set! error-cnt (+ error-cnt 1)))))
       pkg-data)
      (if (not (= error-cnt 0))
	  (process-exit 1))
      ;;
      (with-output-to-file
	  (string-append dir "/shell.c")
	(lambda ()
	  (emit-shell-preamble)
	  (emit-shell-pkgs-line name modules pkg-data)
	  (emit-shell-postamble)))
      ;;
      (with-output-to-file
	  (string-append dir "/Makefile")
	(lambda ()
	  (emit-makefile-pkgs-line name modules pkg-data)
	  (emit-makefile-preamble)
	  (emit-makefile-postamble)))
      ;;
      #t)))
  
(define (get-mx-data pkg)
  (call-with-input-file
      (pathname->os-path
       (append-path (string->dir "[resource]/modules")
		    (string->file (string-append pkg ".mx"))))
    read))

(define (figure-extra-libs pkg)
  (if (equal? "syscalls" pkg)
      (if (memq 'sunos (os-type))
	  '("socket" "nsl")
	  '())
      (figure-extra-libs* pkg)))

(define (figure-extra-libs* pkg)
  (let ((a (assoc pkg '(("db" "db")
			("x11" "gd" "X11")
			("ttywin" "curses")))))
    (if a
	;; for each needed library, make sure we can find it...
	(map
	 (lambda (lib)
	   (if (any? (curry lib-in-place? lib)
		     *standard-lib-places*)
	       lib
	       ;; try to find it elsewhere
	       (let loop ((other *other-lib-places*))
		 (if (null? other)
		     (begin
		       (format *console-error-port*
			       "*** warning: couldn't find lib~a.a\n"
			       lib)
		       #f)
		     (if (lib-in-place? lib (car other))
			 (cons (car other) lib)
			 (loop (cdr other)))))))
	 (cdr a))
	'())))

(define (lib-in-place? lib place)
  (or (os-file-exists? (string-append place "/lib" lib ".a"))
      (os-file-exists? (string-append place "/lib" lib ".so"))))

(define *standard-lib-places* '("/lib" "/usr/lib"))
(define *other-lib-places* '("/usr/local/lib"
			     "/usr/local/rwi/lib"
			     "/usr/X11R6/lib"))

;;=======================================================================
;;      _          _ _       
;;  ___| |__   ___| | |  ___ 
;; / __| '_ \ / _ \ | | / __|
;; \__ \ | | |  __/ | || (__ 
;; |___/_| |_|\___|_|_(_)___|
;;
;;=======================================================================

(define (emit-shell-preamble)
  (display
"#include <rscheme/api.h>
#include <rscheme/stdmodul.h>
#include <rscheme/rlseconf.h>
"))

(define (emit-shell-pkgs-line name modules pkgs)
  (for-each (lambda (p)
	      (format #t "#include <~a.h>\n" p))
	    pkgs)
  (display "struct module_descr *(std_modules[]) = {\n")
  (for-each (lambda (p)
	      (format #t "\t&module_~a,\n" p))
	    pkgs)
  (display "STD_MODULES_DECL };\n\n")
  (format #t "#define DEFAULT_IMG \"/resource/~a.fas\"\n" name))

(define (emit-shell-postamble)
  (display 
"int main( int argc, const char **argv )
{
  char temp[1024];

  rs_install_dir = getenv( \"RS_INSTALL_DIR\" );
  if (!rs_install_dir)
    rs_install_dir = INSTALL_DIR;
  
  sprintf( temp, \"%s\" DEFAULT_IMG, rs_install_dir );
  return rscheme_std_main( argc, argv, std_modules, temp );
}
"))


;;=======================================================================
;;  __  __       _         __ _ _      
;; |  \/  | __ _| | _____ / _(_) | ___ 
;; | |\/| |/ _` | |/ / _ \ |_| | |/ _ \
;; | |  | | (_| |   <  __/  _| | |  __/
;; |_|  |_|\__,_|_|\_\___|_| |_|_|\___|
;;
;;=======================================================================

(define (emit-makefile-preamble)
  (display 
"all:: $(PRODUCT) $(PRODIMG)

XCFLAGS='-DINSTALL_DIR=\"$(INSTALL_DIR)\"'

include $(INSTALL_DIR)/resource/buildenv/preamble.mak

CFILES=shell.c
INSTALL=cp -p

OFILES=$(CFILES:.c=.o)
"))

(define (emit-makefile-pkgs-line name modules pkgs)
  (display "MD=$(INSTALL_DIR)/resource/modules\n")
  (display "LB=$(INSTALL_DIR)/lib\n")
  (format #t "PRODUCT=~a\n" name)
  (format #t "PRODIMG=~a.fas\n" name)
  (display "PKGS=")
  (for-each (lambda (p)
	      (format #t "$(LB)/~a.o " p))
	    pkgs)
  (newline)
  (display "LINKM=")
  (for-each (lambda (p)
	      (format #t "-m $(MD)/~a.mif " p))
	    modules)
  (newline)
  (display "XLDX=")
  (for-each (lambda (lib)
	      (if (pair? lib)
		  (format #t "-L~a -l~a " (car lib) (cdr lib))
		  (if (string? lib)
		      (format #t "-l~a " lib))))
	    (apply append (map figure-extra-libs pkgs)))
  (newline)
  (newline))

(define (emit-makefile-postamble)
  (display
"LIB_RS=$(LB)/librs.a
$(PRODUCT): $(OFILES) $(PKGS) $(LIB_RS)
	$(CC) $(CFLAGS) $(OFILES) $(PKGS) -o $(PRODUCT) $(LDX_FLAGS) $(XLDX)

$(PRODIMG): $(PRODUCT)
	./$(PRODUCT) -image $(INSTALL_DIR)/resource/system.img \\
	      $(LINKM) -c.repl $(PRODIMG)

install:: $(INSTALL_DIR)/bin
	$(INSTALL) $(PRODUCT) $(INSTALL_DIR)/bin
	$(INSTALL) $(PRODIMG) $(INSTALL_DIR)/resource

$(INSTALL_DIR)/bin:
	mkdir $(INSTALL_DIR)/bin

clean::
	rm -f $(OFILES) $(PRODUCT)

depend::
	$(CC) $(CFLAGS) -MM -I. $(CFILES) > depends
"))
