#ifndef _H_LSS
#define _H_LSS

#include <time.h>
#include <rscheme/platform.h>
#include <sys/types.h>

#define LSS_MAGIC  (0x5c4c5353)  /* '\\LSS' */
#define LSS_FMT_VERSION (2)

#define MAX_LSS_CLIENT_SIZE  (256)

typedef struct LSS_CommitInfo {

    UINT_32     lss_magic;
    UINT_32     lss_fmt_version;
    time_t	create_time;
    time_t	commit_time;
    UINT_32     commit_version;
    UINT_32     index_count;
    UINT_32     index_capacity;
    off_t       index_offset;
    off_t       prev_commit_at;

    UINT_32     client_info_len;
    char        spare[8];
} commit_info_t;

struct LSS_Record {
    UINT_32	number;
    off_t	offset;
    UINT_32	length;
};

struct LogStructuredStore;

typedef void lss_error_handler_t( struct LogStructuredStore *lss, 
				  void *info, 
				  int code,
				  char *msg );

typedef struct LogStructuredStore {
    int			fd;
    int                 lock_held;
    UINT_32		index_capacity;
    UINT_32		index_count;
    struct LSS_Record   *index;
    off_t               spare_commit_at;
    commit_info_t	last_commit;
    char                client_commit_info[MAX_LSS_CLIENT_SIZE];
    int                 logfd;   /* not a log as in LSS, more like syslog */
    int                 num_accesses;
    void               *info;
    lss_error_handler_t *error_handler;
} LSS;

typedef struct LSS_Access {
    void	*addr;
    UINT_32	bytes;
    UINT_32	record_num;
} access_t;

#define LSS_CREATE   (1)
#define LSS_WRITE    (2)
#define LSS_LOCK     (4)
#define LSS_KEEP_LOG (8)

#define LSSERR_NOT_LSS (5000)  /* bad magic */
#define LSSERR_LOCKED  (5001)  /* locked already */
#define LSSERR_TOO_BIG (5002)  /* commit info is too big */
#define LSSERR_BAD_VER (5003)  /* incompatible version */
#define LSSERR_SYS_ERR (5004)
#define LSSERR_DEBUG_OPEN_FAILED (5005) /* couldn't satisfy LSS_KEEP_LOG */
#define LSSERR_UNRELEASED_ACCESS (5006) /* unreleased lss_accesses() */
#define LSSERR_NO_RECORD (5007)  /* record doesn't exist */
#define LSSERR_INVALID_ROLLBACK (5008) /* attempt to open old version in update mode */

LSS *lss_open( const char *path, int mode,
	       lss_error_handler_t *initial_handler,
	       void *info,
	       off_t CR_offset );

/* cannot be called while an lss_access() is outstanding... */

void lss_close( LSS *lss );  /* does NOT commit any data */

void set_error_handler( LSS *lss, 
		        lss_error_handler_t *handler,
		        void *info );

void lss_access( LSS *lss, UINT_32 record_num, access_t *a );
void lss_release( LSS *lss, access_t *a );

void lss_write( LSS *lss, UINT_32 record_num, void *data, UINT_32 bytes );

void lss_get_lss_commit_info( LSS *lss, commit_info_t *ci );

void lss_commit( LSS *lss, void *client_info, UINT_32 client_len );
void *lss_get_client_commit_info( LSS *lss, UINT_32 *len );

#endif /* _H_LSS */
