--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it 
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later 
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License 
-- for  more  details.  You  should  have  received a copy of the GNU General 
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class PREFIX_NAME
--   
-- To store a prefix name of operator.
--

inherit FEATURE_NAME;
   
creation make
   
feature    
   
   to_key: STRING;
   
feature {NONE}

   make(n: STRING; sp: like start_position) is
      do
	 to_string := unique_string.item(n);
	 start_position := sp;
	 to_key := unique_string.for_prefix(to_string);
      end;

feature
      
   cpp_put_infix_or_prefix is
      do
	 cpp.put_string(fz_prefix);
	 cpp.put_character(' ');
      end;

   fill_tagged_out_memory is
      do
	 tagged_out_memory.append(to_key);
      end;

feature -- For pretty :

   definition_pretty_print is
      do
	 fmt.keyword(fz_prefix);
	 fmt.put_character('%"');
	 fmt.put_string(to_string);
	 fmt.put_character('%"');
      end;

feature

   short is
      local
	 i: INTEGER;
	 c: CHARACTER;
      do
	 short_print.hook_or("Bpfn","prefix %"");
	 from
	    i := 1;
	 until
	    i > to_string.count
	 loop
	    c := to_string.item(i);
	    short_print.a_character(c);
	    i := i + 1;
	 end;
	 short_print.hook_or("Apfn","%"");
      end;

end -- PREFIX_NAME

