--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it 
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later 
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License 
-- for  more  details.  You  should  have  received a copy of the GNU General 
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class TYPE_REF_TO_EXP

inherit TYPE;

creation {RUN_CLASS} make

feature

   run_class: RUN_CLASS;
   
   written_mark: STRING;

feature {NONE}

   expanded_type: TYPE;
	 -- The corresponding one.

feature {NONE}

   make(model: TYPE) is
      require
	 model.is_expanded;
	 model.run_type = model;
      do
	 expanded_type := model;
	 tmp_string.copy("ref. to ");
	 tmp_string.append(model.run_time_mark);
	 written_mark := unique_string.item(tmp_string);
	 run_class := small_eiffel.run_class(Current)
	 run_class.set_at_run_time;
      ensure
	 run_class.at_run_time
      end;

feature

   is_run_type: BOOLEAN is true;

   is_expanded: BOOLEAN is false;

   is_reference: BOOLEAN is true;

   is_basic_eiffel_expanded: BOOLEAN is false;

   is_user_expanded: BOOLEAN is false;

   is_dummy_expanded: BOOLEAN is false;

   need_gc_mark_function: BOOLEAN is true;

   need_c_struct: BOOLEAN is true;

feature

   id: INTEGER is
      do
	 Result := run_class.id;
      end;

   used_as_reference is
      do
      end;

   start_position: POSITION is
      do
      end;

   is_generic: BOOLEAN is
      do
	 Result := expanded_type.is_generic;
      end;

   run_type: TYPE is
      do
	 Result := Current;
      end;

   generic_list: ARRAY[TYPE] is
      do
	 Result := expanded_type.generic_list;
      end;

   run_time_mark: STRING is
      do
	 Result := written_mark;
      end;

   base_class_name: CLASS_NAME is
      do
	 Result := expanded_type.base_class_name;
      end;

   to_runnable(ct: TYPE): like Current is
      do
	 Result := Current;
      end;

   is_a(other: TYPE): BOOLEAN is
      do
	 if other.run_time_mark /= expanded_type.run_time_mark then
	    Result := expanded_type.is_a(other);
	 end;
      end;

   has_creation(fn: FEATURE_NAME): BOOLEAN is
      do
      end;

   smallest_ancestor(other: TYPE): TYPE is
      do
	 fatal_error("TYPE_REF_TO_EXP Not Yet Implemented #1");
      end;

   just_before_gc_mark_in(str: STRING) is
      do
	 standard_just_before_gc_mark_in(str);
      end;

   gc_info_in(str: STRING) is
      do
	 standard_gc_info_in(str);
      end;

   gc_define1 is
      do
	 standard_gc_define1;
      end;

   gc_define2 is
      do
	 standard_gc_define2;
      end;

   space_for_variable: INTEGER is
      do
	 Result := space_for_pointer;
      end;

   expanded_initializer: RUN_FEATURE_3 is
      do
      end;

   c_type_for_argument_in(str: STRING) is
      do 
	 str.append(fz_t0_star);
      end;

   c_type_for_target_in(str: STRING) is
      do
	 str.extend('T');
	 id.append_in(str);
	 str.extend('*');
      end;

   c_type_for_result_in(str: STRING) is
      do
	 str.append(fz_t0_star);
      end;

   c_header_pass1 is
      do
	 standard_c_typedef;
      end;

   c_header_pass2 is
      do
      end;

   c_header_pass3 is
      do
      end;

   c_header_pass4 is
      local
	 rc: RUN_CLASS;
	 mem_id: INTEGER;
      do
	 expanded_type.run_class.c_header_pass4;
	 rc := run_class;
	 mem_id := rc.id;
	 -- C struct :
	 tmp_string.copy(fz_struct);
	 tmp_string.extend('S');
	 mem_id.append_in(tmp_string);
	 tmp_string.append("{int id;T");
	 expanded_type.id.append_in(tmp_string);
	 tmp_string.append(" _item;};%N");
	 cpp.put_string(tmp_string);
	 -- Model :
	 tmp_string.clear;
	 tmp_string.extend('T');
	 mem_id.append_in(tmp_string);
	 tmp_string.extend(' ');
	 tmp_string.extend('M');
	 mem_id.append_in(tmp_string);
	 cpp.put_extern7(tmp_string);
	 cpp.swap_on_c;
	 tmp_string.clear;
	 tmp_string.extend('{');
	 mem_id.append_in(tmp_string);
	 tmp_string.extend(',');
	 expanded_type.run_class.c_object_model_in(tmp_string);
	 tmp_string.extend('}');
	 tmp_string.append(fz_00);
	 cpp.put_string(tmp_string);
	 cpp.swap_on_h;
	 -- Print function :
	 if run_control.no_check then
	    header.copy("void se_prinT");
	    mem_id.append_in(header);
	    header.append("(T");
	    mem_id.append_in(header);
	    header.append("**o)");
	    body.copy("if(*o==NULL){%N%
		      %printf(%"Void%");%Nreturn;%N}%N%
		      %printf(%"");
	    body.append(written_mark);
	    body.append("%");%N%
			%printf(%"#%%p%",*o);%N%
		        %printf(%"[%");%N%
                        %printf(%"\n\t%");%N%
                        %printf(%"item = %");%N%
                        %se_prinT");
	    expanded_type.id.append_in(body);
	    body.append("((void*)(&((*o)->_item)));%N%
                        %printf(%"\n\t]%");");
	    cpp.put_c_function(header,body);
	 end;
      end;

   c_initialize is
      do
	 cpp.put_string(fz_null);
      end;
   
   c_initialize_in(str: STRING) is
      do
	 str.append(fz_null);
      end;

feature

   jvm_method_flags: INTEGER is 
      do
	 Result := 17;
      end;

   jvm_descriptor_in(str: STRING) is
      do
	 str.append(jvm_root_descriptor);
      end;

   jvm_target_descriptor_in(str: STRING) is
      do
      end;

   jvm_return_code is
      do
	 code_attribute.opcode_areturn;
      end;

   jvm_check_class_invariant is
      do
	 standard_jvm_check_class_invariant;
      end;

   jvm_push_local(offset: INTEGER) is
      do
	 code_attribute.opcode_aload(offset);
      end;

   jvm_push_default: INTEGER is
      do
	 Result := 1;
	 code_attribute.opcode_aconst_null;
      end;

   jvm_initialize_local(offset: INTEGER) is
      do
	 code_attribute.opcode_aconst_null;
	 jvm_write_local(offset);
      end;

   jvm_write_local(offset: INTEGER) is
      do
	 code_attribute.opcode_astore(offset);
      end;

   jvm_xnewarray is
      local
	 idx: INTEGER;
      do
	 idx := constant_pool.idx_jvm_root_class;
	 code_attribute.opcode_anewarray(idx);
      end;

   jvm_xastore is
      do
	 code_attribute.opcode_aastore;
      end;

   jvm_xaload is
      do
	 code_attribute.opcode_aaload;
      end;

   jvm_if_x_eq: INTEGER is
      do
	 Result := code_attribute.opcode_if_acmpeq;
      end;

   jvm_if_x_ne: INTEGER is
      do
	 Result := code_attribute.opcode_if_acmpne;
      end;

   jvm_to_reference is
      do
      end;

   jvm_to_expanded: INTEGER is
      do
	 Result := 1;
      end;

   jvm_convert_to(destination: TYPE): INTEGER is
      do
	 Result := 1;
      end;

feature

   short_hook is
      do
	 expanded_type.short_hook;
      end;

end -- TYPE_REF_TO_EXP
