-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
class LINK2[E]
   --
   -- To implement LINK2_LIST[E].
   --

inherit LINK[E] rename make as link_make end;
   
creation {LINK2_LIST}
   make

feature {LINK2_LIST,LINK2}
   
   previous: like Current;

feature {LINK2_LIST}

   make(i: like item; p: like previous; n: like next) is
      do
	 item := i;
	 previous := p;
	 next := n;
      ensure
	 item = i;
	 previous = p;
	 next = n
      end;
   
feature {LINK2_LIST,LINK2}

   set_previous(p: like previous) is
      do
	 previous := p;
      ensure
	 previous = p
      end;

end -- LINK2[E]


