-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
deferred class  NUMERIC
--
-- This class describes a ring.
--
   
inherit
   HASHABLE 
      undefine is_equal
      end;
   
feature  

   infix "+" (other: like Current): like Current is
	 -- Sum of 'Current' and 'other'.
      require
	 other /= Void
      deferred
      end;
   
   infix "-" (other: like Current): like Current is
	 -- Difference of 'Current' and 'other'.
      require
	 other /= Void
      deferred
      end;

   infix "*" (other: like Current): like Current is
	 -- Product of 'Current' and 'other'.
      require
	 other /= Void
      deferred
      end;
   
   infix "/" (other: like Current): NUMERIC is
	 -- Quotient of 'Current' and 'other'.
      require
	 other /= Void;
	 divisible (other)
      deferred
      end;

   infix "^" (exp: INTEGER): NUMERIC is
	 -- 'Current' raised to 'exp'-th power.
      require
	 exp >= 0 
      local
	 e      : INTEGER;
	 product: like Current;
	 factor : like Current;
      do
	 product := one;
	 factor  := Current;
	 from
	    e := exp;
	 until
	    e = 0
	 loop
	    if (e \\ 2) = 1 then
	       product := product * factor
	    end;
	    e := e // 2;
	    factor := factor * factor;
	 end;
	 Result := product;
      end;

   prefix "+" : like Current is
	 -- Unary plus of 'Current'.
      do
	 Result := Current
      end;

   prefix "-" : like Current is
	 -- Negative of `Current'.
      do
	 Result := zero - Current
      end;

   divisible(other: like Current): BOOLEAN is
	 -- Is `other' a valid divisor for `Current' ?
      require
	 other /= Void
      deferred
      end;

   one: like Current is
	 -- The neutral element of multiplication.
      deferred
      ensure
	 neutral_element: -- Result is the neutral element of 
	 -- multiplication.
      end;

   zero: like Current is
	 -- The neutral element of addition.
      deferred
      ensure
	 neutral_element: -- Result is the neutral element of 
	 -- addition.
      end;
   
   sign: INTEGER is
      do
	 if Current > zero then
	    Result := 1;
	 elseif Current < zero then
	    Result := -1;
	 end;
      end;

   infix "<" (other: like Current): BOOLEAN is
      deferred
      end;

   infix ">" (other: like Current): BOOLEAN is
      deferred
      end;

end --  NUMERIC


