#
# Tcl Library for tkCVS
#

#
# $Id: import.tcl,v 1.15.2.6 1998/09/18 20:26:16 dorothyr Exp $
#
# Adds a new document to the repository.
#

proc import_setup {} {
  global cvsglb

  # Give it a default
  set cvsglb(newvers) 1

  toplevel .import
  frame .import.left
  frame .import.right
  frame .import.down -relief groove -border 2

  # When packing, I only want the right hand side and the buttons
  # to be interactively strechable (in case the user wants more space
  # to enter long document names).

  pack .import.down -side bottom -fill x -expand 1
  pack .import.left -side left -fill y
  pack .import.right -side left -fill both -expand 1

  label .import.lnewdir  -text "Module Directory" -anchor w
  label .import.lnewname -text "Module Name" -anchor w
  label .import.lnewvers  -text "Version Number" -anchor w
  label .import.lnewcode -text "Module Code" -anchor w

  entry .import.tnewdir -relief sunken -textvariable cvsglb(newdir) -width 40
  entry .import.tnewname -relief sunken -textvariable cvsglb(newname) -width 40
  entry .import.tnewvers -relief sunken -textvariable cvsglb(newvers) -width 40
  entry .import.tnewcode -relief sunken -textvariable cvsglb(newcode) -width 40

  # bind_motifentry .import.tnewdir
  # bind_motifentry .import.tnewname
  # bind_motifentry .import.tnewvers
  # bind_motifentry .import.tnewcode

  pack .import.lnewdir .import.lnewname \
    .import.lnewvers .import.lnewcode -in .import.left \
    -side top -fill x -pady 3

  pack .import.tnewdir .import.tnewname \
    .import.tnewvers .import.tnewcode -in .import.right \
    -side top -fill both -expand 1 -pady 3

  button .import.ok -text "OK" \
    -command do_import
  button .import.newdir -text "New Directory" \
    -command inewdir_run
  button .import.quit -text "Quit" \
    -command { wm withdraw .import }

  pack .import.ok .import.newdir .import.quit -in .import.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  wm withdraw .import
  wm title .import "Import a New Module"
  wm minsize .import 1 1

  toplevel .inewdir
  frame .inewdir.left
  frame .inewdir.right
  frame .inewdir.down -relief groove -border 2

  # When packing, I only want the right hand side and the buttons
  # to be interactively strechable (in case the user wants more space
  # to enter long document names).

  pack .inewdir.down -side bottom -fill x -expand 1
  pack .inewdir.left -side left -fill y
  pack .inewdir.right -side left -fill both -expand 1

  label .inewdir.lnewdir  -text "New Directory Location" -anchor w
  label .inewdir.lnewname -text "New Directory Name" -anchor w

  entry .inewdir.tnewdir -relief sunken -textvariable cvsglb(dnewdir) -width 40
  entry .inewdir.tnewname -relief sunken -textvariable cvsglb(dnewname) -width 40

  # bind_motifentry .inewdir.tnewdir
  # bind_motifentry .inewdir.tnewname

  pack .inewdir.lnewdir .inewdir.lnewname \
    -in .inewdir.left \
    -side top -fill x -pady 3

  pack .inewdir.tnewdir .inewdir.tnewname \
    -in .inewdir.right \
    -side top -fill both -expand 1 -pady 3

  button .inewdir.ok -text "OK" \
    -command do_inewdir
  button .inewdir.quit -text "Quit" \
    -command { wm withdraw .inewdir }

  pack .inewdir.ok .inewdir.quit -in .inewdir.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  wm withdraw .inewdir
  wm title .inewdir "Import a New Directory"
  wm minsize .inewdir 1 1
}

proc import_run {} {
  global cvsglb
  global cvscfg
  global cwd

  if {$cvscfg(cvsver) < 1.3} {
    cvserror "This function is not available in CVS version $cvscfg(cvsver).

Please upgrade your CVS to version 1.3 or later or use Add instead."
    return 1
  }

  set cvsglb(newcode) [file tail $cwd]
  wm deiconify .import
}

proc inewdir_run {} {
  wm deiconify .inewdir
}

proc append_modules_file { puts_lines } {
      global cvs
      global cvsglb
      global cvscfg
      if { $cvscfg(cvs-modfile) == 1 } {
          cd
      catch {exec $cvs -d $cvscfg(cvsroot) co modules}
              cd modules
              set modfile [open modules a]
              foreach puts_line in $puts_lines {
                      puts $modfile $puts_line
              }
              close $modfile
              catch {exec $cvs -d $cvscfg(cvsroot) ci -m "added $cvsglb(newcode)" modules}
      } else {
              # cvscfg(modfile) should be valid here,
              # so we use the name determined by proc 'get_modules_file'
              if { $cvscfg(remote) == 1 } {
                      # again get a copy
                      get_remote_copy_modules_file
              } else {
                      # do nothing
              }
              # append
              set modfile [open $cvscfg(modfile) a]
              foreach puts_line $puts_lines {
                      puts $modfile $puts_line
              }
              close $modfile
              if { $cvscfg(remote) == 1 } {
                      # write back
                      put_remote_copy_modules_file
              } else {
                      # do nothing
              }
      }
}
proc do_import {} {
  global cvs
  global cvsglb
  global cvscfg
  global cwd
  global incvs
  global dtitle
  global dcontents

  # Error checks

  if {$incvs} {
    cvserror "This directory is already in CVS.\nCant import here!"
    return 1
  }
  if { $cvsglb(newdir) == "" } {
    cvserror "You must type in a directory!"
    return 1
  }
  if { $cvsglb(newname) == "" } {
    cvserror "You must type in a module name!"
    return 1
  }
  if { $cvsglb(newvers) == "" } {
    cvserror "You must type in a version number!"
    return 1
  }
  if { $cvsglb(newcode) == "" } {
    cvserror "You must type in a module code!"
    return 1
  }

  # Check that all apropriate Directories in newdirname exist
  set cvsglb(newdir) [string trimleft $cvsglb(newdir) "/"]
  set checkdirname [file dirname $cvsglb(newdir)]
  if {$checkdirname != "."} {
    if {[lsearch -exact [array names dtitle] $checkdirname] == -1} {
     cvserror "The upper directory doesnt exist."
     return 1
    }
  }

  set create_module 1
  if {[lsearch -exact [array names dtitle] $cvsglb(newdir)] >= 0} {
    set mess "NOTE:  You are importing a new baseline of a directory that already exists!"
    set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]
    if {$confirm == 0} {
      set create_module 0
    } else {
      return 1
    }
  }
  set ndir [file dirname $cvsglb(newdir)]
  if { [info exists dcontents($ndir)] && {$create_module == 0}} {
    if {[lsearch -exact $dcontents($ndir) $cvsglb(newcode)] >= 0} {
      set mess "NOTE:  You are importing over a directory that already exists!"
      set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit] 
      if {$confirm == 0} {
        set create_module 0
      } else {
        return 1
      }
    }
  }

  # Make a baseline tag

  set versions [split $cvsglb(newvers) ".,/ -"]
  set baseline "baseline-[join $versions {_}]"

  feedback_cvs "Importing $cvsglb(newcode), please wait"
  set retcode [catch {exec \
      $cvs -d $cvscfg(cvsroot) import -m "Imported using tkCVS" \
           $cvsglb(newdir) VENDOR $baseline} \
           view_this]
  if $retcode {
    error $view_this
  }
  feedback_cvs ""

  view_output "CVS Import" $view_this

  # Update the modules file.

  if {$create_module == 1} {
    if { ! [file isdir tkcvstempdir] } {
      if [catch {exec mkdir tkcvstempdir} message] {
        error $message
      }
    }
    cd tkcvstempdir                       
    set retcode [catch {exec \
        $cvs -d $cvscfg(cvsroot) co CVSROOT/modules} \
         message]
    if $retcode {
      error $message
    }
    cd CVSROOT                            
    set modfile [open modules a]
      puts $modfile ""
      puts $modfile "#D $cvsglb(newcode)	$cvsglb(newname)" 
      puts $modfile "#M	$cvsglb(newcode)	$cvsglb(newname)"
      puts $modfile "$cvsglb(newcode)	$cvsglb(newdir)"
    close $modfile
      set retcode [catch {exec \
          $cvs -d $cvscfg(cvsroot) ci -m "added $cvsglb(newcode)" modules} \
          message]
    if $retcode {
      error $message
    }
    cd ../..                              
    catch {exec rm -r tkcvstempdir}       
    cd $cwd
  }

  read_modules_setup
  checkout_fill_listbox
  wm withdraw .import
}

proc do_inewdir {} {
  global cvsglb
  global cvs
  global cwd
  global dtitle

  # Error checks

  if { $cvsglb(dnewdir) == "" } {
    cvserror "You must type in a directory!"
    return 1
  }
  if { $cvsglb(dnewname) == "" } {
    cvserror "You must type in a directory name!"
    return 1
  }

  # Check that all apropriate Directories in newdirname exist
  set cvsglb(dnewdir) [string trimleft $cvsglb(dnewdir) "/"]
  set checkdirname [file dirname $cvsglb(dnewdir)]
  if {$checkdirname != "."} {
    if {[lsearch -exact [array names dtitle] $checkdirname] == -1} {
     cvserror "The upper directory doesnt exist."
     return 1
    }
  }

  if {[lsearch -exact [array names dtitle] $cvsglb(dnewdir)] >= 0} {
     cvserror "This directory already exists!"
     return 1
  }

  cd
  catch {exec $cvs -d $cvscfg(cvsroot) co modules}
  cd modules
  set modfile [open modules a]
    puts $modfile ""
    puts $modfile "#D	$cvsglb(dnewdir)	$cvsglb(dnewname)"
  close $modfile
  catch {exec $cvs -d $cvscfg(cvsroot) ci -m "added $cvsglb(dnewdir)" modules}
  cd $cwd

  read_modules_setup
  checkout_fill_listbox
}
