#include "header.h"

Selector::Selector(Line* l, Style* s) : InputHandler(l, s), line_(l) {
        l->set_linetype('d');
}

void Selector::keystroke(const Event& e) {
    const int buflen = 10;
    char buffer[buflen];

    int l = e.mapkey(buffer,buflen);
    if ( buffer[0]=='d' || buffer[0]=='h' || buffer[0]=='v' ) {
       line_->set_linetype(buffer[0]);
    }
    else 
     if ( buffer[0]=='q' )
        Session::instance()->quit();
    redraw();
    InputHandler::keystroke(e);
}

void Selector::press(const Event& e) {

   if (e.pointer_button()==Event::left) {
      cerr << "left mousebutton pressed, ";
      cerr << "on the coordinates : ";
      cerr << "x = " << e.pointer_x() << " and ";
      cerr << "y = " << e.pointer_y() << "\n";
   }
   InputHandler::press(e);
}

