/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs.h,v 1.7 1998/10/16 20:20:29 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PREFS_H__
#define __PREFS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "main.h"

/* general/global options and macros */
#define AUTO_INDENT			0x00000001
#define SHOW_TABS			0x00000002
#define SHOW_MSGBAR			0x00000004
#define SHOW_TOOLBAR			0x00000008
#define PIC_TEXT_TOOLBAR		0x00000010
#define TEXT_ONLY_TOOLBAR		0x00000020
#define PIC_ONLY_TOOLBAR		0x00000040
#define SHOW_TOOLTIPS			0x00000080
#define USE_WORDWRAP			0x00000100
#define SAVE_WIN_WIDTH			0x00000200
#define SAVE_WIN_HEIGHT			0x00000400
#define SAVE_WIN_POS			0x00000800
#define USE_MSGBOX			0x00001000
#define SHOW_PRJBAR			0x00002000

#define DEFAULT_OPTIONS (AUTO_INDENT | SHOW_TABS | SHOW_MSGBAR | \
			SHOW_TOOLBAR | PIC_TEXT_TOOLBAR |SHOW_TOOLTIPS | \
			SAVE_WIN_HEIGHT | USE_MSGBOX)

/* these macros operate on the global variable 'options' */
#define IS_AUTO_INDENT()		(options & AUTO_INDENT)
#define IS_SHOW_TABS()			(options & SHOW_TABS)
#define IS_SHOW_MSGBAR()		(options & SHOW_MSGBAR)
#define IS_SHOW_TOOLBAR()		(options & SHOW_TOOLBAR)
#define IS_TEXT_PIC_TOOLBAR()		(options & PIC_TEXT_TOOLBAR)
#define IS_TEXT_TOOLBAR()		(options & TEXT_ONLY_TOOLBAR)
#define IS_PIC_TOOLBAR()		(options & PIC_ONLY_TOOLBAR)
#define IS_SHOW_TOOLTIPS()		(options & SHOW_TOOLTIPS)
#define IS_USE_WORDWRAP()		(options & USE_WORDWRAP)
#define IS_USE_MSGBOX()			(options & USE_MSGBOX)
#define IS_SAVE_WIN_WIDTH()		(options & SAVE_WIN_WIDTH)
#define IS_SAVE_WIN_HEIGHT()		(options & SAVE_WIN_HEIGHT)
#define IS_SAVE_WIN_POS()		(options & SAVE_WIN_POS)
#define IS_SHOW_PRJBAR()		(options & SHOW_PRJBAR)

#define SET_AUTO_INDENT()		(options |= AUTO_INDENT)
#define SET_SHOW_TABS()			(options |= SHOW_TABS)
#define SET_SHOW_MSGBAR()		(options |= SHOW_MSGBAR)
#define SET_SHOW_TOOLBAR()		(options |= SHOW_TOOLBAR)
#define SET_TEXT_ONLY_TOOLBAR()		(options |= TEXT_ONLY_TOOLBAR)
#define SET_PIC_ONLY_TOOLBAR()		(options |= PIC_ONLY_TOOLBAR)
#define SET_PIC_TEXT_TOOLBAR()		(options |= PIC_TEXT_TOOLBAR)
#define SET_SHOW_TOOLTIPS()		(options |= SHOW_TOOLTIPS)
#define SET_USE_WORDWRAP()		(options |= USE_WORDWRAP)
#define SET_USE_MSGBOX()		(options |= USE_MSGBOX)
#define SET_SAVE_WIN_WIDTH()		(options |= SAVE_WIN_WIDTH)
#define SET_SAVE_WIN_HEIGHT()		(options |= SAVE_WIN_HEIGHT)
#define SET_SAVE_WIN_POS()		(options |= SAVE_WIN_POS)
#define SET_SHOW_PRJBAR()		(options |= SHOW_PRJBAR)

#define CLEAR_AUTO_INDENT()		(options &= ~AUTO_INDENT)
#define CLEAR_SHOW_TABS()		(options &= ~SHOW_TABS)
#define CLEAR_SHOW_MSGBAR()		(options &= ~SHOW_MSGBAR)
#define CLEAR_SHOW_TOOLBAR()		(options &= ~SHOW_TOOLBAR)
#define CLEAR_PIC_TEXT_TOOLBAR()	(options &= ~PIC_TEXT_TOOLBAR)
#define CLEAR_TEXT_ONLY_TOOLBAR()	(options &= ~TEXT_ONLY_TOOLBAR)
#define CLEAR_PIC_ONLY_TOOLBAR()	(options &= ~PIC_ONLY_TOOLBAR)
#define CLEAR_SHOW_TOOLTIPS()		(options &= ~SHOW_TOOLTIPS)
#define CLEAR_USE_WORDWRAP()		(options &= ~USE_WORDWRAP)
#define CLEAR_USE_MSGBOX()		(options &= ~USE_MSGBOX)
#define CLEAR_SAVE_WIN_WIDTH()		(options &= ~SAVE_WIN_WIDTH)
#define CLEAR_SAVE_WIN_HEIGHT()		(options &= ~SAVE_WIN_HEIGHT)
#define CLEAR_SAVE_WIN_POS()		(options &= ~SAVE_WIN_POS)
#define CLEAR_SHOW_PRJBAR()		(options &= ~SHOW_PRJBAR)

extern char *		appdir;		/* $HOME/.gnp */
extern GtkPositionType	tabpos;		/* doc tab position */
extern guint		autosave;	/* minutes for autosave (0 disables) */
extern char *		printcmd;	/* print cmd. 'lpr' */
extern char *		tmpdir;		/* temp directory. '/var/tmp' */
extern long		options;	/* bit flag options.  see above */
extern ubyte		maxrecent;	/* max number of recently opened docs */
extern guint		msgbox_max_msg;	/* max num of msgs in msg box */
extern guint		msgbox_per_del;	/* num of msgs to delete in msg box */
extern int		win_height;	/* window height */
extern int		win_width;	/* window width */
extern int		win_xpos;	/* window's xposition */
extern int		win_ypos;	/* window's yposition */
extern GdkColor		text_fg_color;	/* text foreground color */
extern GdkColor		text_bg_color;	/* text background color */
extern GdkFont *	text_font;	/* text font */


extern void	prefs_init(void);
extern void	prefs_save(void);
extern void	prefs_cb(GtkWidget *wgt, gpointer cbdata);
extern void	prefs_text_color_update(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PREFS_H__ */
