//  AString.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include "AString.h"
#include <UCommon.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>

AString::AString(void)
{
	string = 0;
}

AString::AString (const AString& strIn)
{
	string=0;
	if (!strIn.isNull()) 
	{
		string=new char [strlen ((const char*) strIn) +1];
		CHECKNULL (string);
		strcpy (string, (const char*) strIn);
	}
}

AString::AString (const char* strIn)
{
	string=0;
	if (strIn!=0) 
	{
		string=new char [strlen (strIn) +1];
		CHECKNULL (string);
		strcpy (string, strIn);
	}
}

AString::~AString ()
{
	if (string!=0) delete string;
}

AString&
AString::operator= (const AString& strIn)
{
	char*		newVle;

	if (strIn.isNull())
	{
		if (string!=0) delete string;
		string = 0;
		return *this;
	}
	newVle=new char [strlen ((const char*) strIn) +1];
	CHECKNULL (newVle);
	strcpy (newVle, (const char*) strIn);
	if (string!=0)
	{
		delete string;
	}
	string=newVle;
	return *this;
}

AString&
AString::operator= (const char *strIn)
{
	char*		newVle;

	if (strIn==0)
	{
		if (string!=0) delete string;
		string = 0;
		return *this;
	}
	newVle=new char [strlen (strIn) +1];
	CHECKNULL (newVle);
	strcpy (newVle, strIn);
	if (string!=0)
	{
		delete string;
	}
	string=newVle;
	return *this;
}

AString&
AString::operator+= (const char *strIn)
{
	char*		newVle;

	if (strIn==0)
	{
		return *this;
	}
	newVle=new char [(string==0) ? strlen (strIn) + 1 
		: strlen(string) + strlen (strIn) +1];
	CHECKNULL (newVle);
	strcpy (newVle, (string==0) ? "" : string);
	strcat (newVle, strIn);
	if (string!=0)
	{
		delete string;
	}
	string=newVle;
	return *this;
}

AString::operator const char* () const
{
	return string;
}

int
AString::toInt ()
{
	 return atoi (string);
}

AStringList::AStringList ()
{
	size = 0;
	arraySize = 0;
	elements = 0;
}

AStringList::AStringList (const AStringList& strIn)
{
	copy (strIn);
}

void
AStringList::copy (const AStringList& strIn)
{
	int	newSize;
	int	newArraySize;
	char**	newElements;
	int	i;

	newSize = strIn.size;
	newArraySize = strIn.arraySize;
	newElements = 0;
	if (newArraySize>0)
	{
		newElements = new char* [newArraySize];	
		for (i=0; i<strIn.size; i++)
		{
			newElements[i] = new char [strlen (strIn.at(i))+1];
			strcpy (newElements[i], strIn.at(i));
		}
	}
	clear ();
	size = newSize;
	arraySize = newArraySize;
	elements = newElements;
}

AStringList::~AStringList ()
{
	clear ();
}

void
AStringList::clear ()
{
	int	i;
	for (i=0; i<size; i++)
	{
		delete elements[i];
	}
	if (elements) delete elements;
	elements=0;
	size=0;
	arraySize=0;
}

void
AStringList::add (const char* element)
{
	int	newSize;
	char** 	newArray;
	int	len;
	
	if (size >= arraySize)
	{
		newSize = (arraySize==0) ? 1: arraySize<<1;
		newArray = new char*[newSize];
		CHECKNULL (newArray);
		if (size>0)
		{
			memcpy (newArray, elements, size * sizeof (char*));
			delete elements;
		}
		elements = newArray;
		arraySize = newSize;
	}
	len = strlen (element);
	elements[size] = new char[len+1];
	CHECKNULL (elements[size]);
	memcpy (elements[size], element, len+1);
	size++;
}

//
// same as add but it adds to the end
//
void
AStringList::push (const char* element)
{
	int	newSize;
	char** 	newArray;
	int	len;
	int	i;
	
	if (size >= arraySize)
	{
		newSize = (arraySize==0) ? 1: arraySize<<1;
		newArray = new char*[newSize];
		CHECKNULL (newArray);
		if (size>0)
		{
			memcpy (newArray, elements, size * sizeof (char*));
			delete elements;
		}
		elements = newArray;
		arraySize = newSize;
	}
	len = strlen (element);
	for (i=size; i>0; i--) elements[i] = elements[i-1];
	elements[0] = new char[len+1];
	CHECKNULL (elements[0]);
	memcpy (elements[0], element, len+1);
	size++;
}

void
AStringList::addCaseSorted (const char* element)
{
	int	newSize;
	char** 	newArray;
	int	len;
	int	keyPos;
	int	i;
	
	if (size >= arraySize)
	{
		newSize = (arraySize==0) ? 1: arraySize<<1;
		newArray = new char*[newSize];
		CHECKNULL (newArray);
		if (size>0)
		{
			memcpy (newArray, elements, size * sizeof (char*));
			delete elements;
		}
		elements = newArray;
		arraySize = newSize;
	}

	keyPos = binaryCaseSearch (element);
	// Move guys up
	for (i=size; i>keyPos; i--)
	{
		elements[i] = elements[i-1];
	}
	len = strlen (element);
	elements[keyPos] = new char[len+1];
	CHECKNULL (elements[keyPos]);
	memcpy (elements[keyPos], element, len+1);
	size++;
}

int
AStringList::binaryCaseSearch (const char* key)
{
	int	top;
	int	bottom;
	int	mid;	
	int	cmp;	

	bottom=0;
	top=size;
	mid=0;
	while (top > bottom)
	{
		mid = (top+bottom)/2;
		cmp = strcasecmp (key, elements[mid]);
		if (cmp==0) return mid;
		if (cmp < 0)
		{
			top = mid;
			continue;
		}
		bottom = mid+1;
	}
	return top;
}


const char *
AStringList::at (const int position) const
{
	if (position>size || position < 0) return 0;
	return elements[position];
}

int
AStringList::getSize () const
{
	return size ;
}

AStringList&
AStringList::operator= (const AStringList&  strIn)
{
	copy (strIn);
	return *this;
}
