//  UCommon.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UCommon.h"
#include "UString.h"
#include <string.h>
#include <sys/stat.h>
#include "UFontMap.h"
#include "UFreeType.h"
#include "UFontFreeType.h"

static char* defaultMapPath=".";

static char* mapPath=defaultMapPath;

const char*
UGetMapPath ()
{
	return mapPath;
}

void
USetMapPath (const char* newPathIn)
{
	char*	newPath;

	newPath = new char[strlen (newPathIn) +1];
	CHECKNULL (newPath);
	strcpy (newPath, newPathIn);

	if (mapPath!=defaultMapPath && mapPath!=0)
	{
		delete mapPath;
	}
	mapPath = newPath;
}

int
UCS2Len (const UCS2* text, int * tabCount)
{
	int	i=0;
	if (tabCount) *tabCount=0;
	while (text[i]!=0)
	{
		if (tabCount != 0 && text[i] == (UCS2) '\t') (*tabCount)++;
		i++;
	}
	return i;
}

//
// double null terminated string.
// return the "real length" that is the length without termination
int
UStrLen (const unsigned char* dchar)
{
	int	i=0;
	while (!(dchar[i]==0 && dchar[i+1]==0 
		&& dchar[i+2] == 0 && dchar[i+3]==0xff)) i++;
	return i;
}

int 
USplit (UCS2* text, UCS2*** ret)
{
	int	i;
	int	index;
	int	len;

	len=0;
	for (i=0; text[i] != 0; i++) 
	{
		if (text[i]=='\n') len++;
	}
	if (text[i]!='\n') len++;
	*ret = new UCS2*[len+1];
	CHECKNULL (*ret);
	index =0;
	(*ret)[index++] = &text[0];
	for (i=0; text[i] != 0; i++)
	{
		if (text[i]=='\n')
		{
			text[i]=0;
			(*ret)[index++] = &text[i+1];
		}
	}
	return len;
}

// get buffer line by line, make sure it is double terminated
unsigned char*
UReadBuffer (istream* is)
{
	int		bufferSize;
	int		size;
	int		newBufferSize;
	unsigned char*	newBuffer;
	unsigned char*	buffer;

	bufferSize = 256;
	buffer = new unsigned char[bufferSize];
	CHECKNULL (buffer);
	size=0;
	while (is->get(buffer[size]))
	{
		size++;
		if (size+5<bufferSize) continue;
		newBufferSize = bufferSize<< 1;
		newBuffer =  new unsigned char[newBufferSize];
		CHECKNULL (newBuffer);
		memcpy (newBuffer, buffer, size);
		delete buffer;
		buffer = newBuffer;
		bufferSize = newBufferSize;
	}
	buffer[size++]=0;
	buffer[size++]=0;
	buffer[size++]=0;
	buffer[size++]=0xff;
	return buffer;
}

//
// zero on failure
//
int
UWriteBuffer (ostream* os, const unsigned char *buffer)
{
	int	len;

	len = UStrLen(buffer);
	if (!os->write (buffer, len)) return -1;
	return len;
}

UCS2*
UCS2Get (const unsigned char* in, int extraLen)
{
	UCS2*	retVle;
	int	i;

	retVle = new UCS2[strlen ((const char*) in) + extraLen +1];
	CHECKNULL (retVle);
	for (i=0; in[i] != 0; i++)
	{
		retVle[i] = (UCS2) in[i];
	}
	retVle[i] = 0;
	return retVle;
}

UCS2*
UCS2Dup (const UCS2* text, const int extraLen)
{
	UCS2*   retVle;
	int	len;

	len = UCS2Len (text);
	retVle = new UCS2[len+extraLen+1];
	memcpy (retVle, text, len * sizeof(UCS2));
	retVle[len]=0;
	return retVle;
}

UCS2*
UCS2Concat (const UCS2* text0, const UCS2* text1)
{
	UCS2*   retVle;
	int	len0;
	int	len1;

	len0 = UCS2Len (text0);
	len1 = UCS2Len (text1);
	retVle = new UCS2[len0+len1+1];
	if (len0 > 0) memcpy (retVle, text0, len0 * sizeof(UCS2));
	if (len1 > 0) memcpy (&retVle[len0], text1, len1 * sizeof(UCS2));
	retVle[len0+len1]=0;
	return retVle;
}

#define UTValue(_v) _v

const char*
UWidgetVersion()
{
	return  UTValue ("yudit version 1.1\nGNU Copyright (C) gsinai@iname.com (Gaspar Sinai)\nTokyo, 23 August 1998");
}

char*
UFindFile (const char* path, const char *name)
{
	int		from;
	int		to;
	int		length;
	char*		pathName;
	struct stat 	buf;
	
	length = strlen (path);
	to = 0;
	from = 0;
	while (to<length)
	{
		while (path[to] != ':' && path[to] != 0) to++;
		if (to==from) { to++; from=to; continue; }
		pathName = new char[to-from +strlen (name) +2]; 
		CHECKNULL (pathName);

		memcpy (pathName, &path[from], to-from);

		pathName[to-from] = 0;
		if (pathName[to-from-1] != '/') strcat (pathName, "/");
		strcat (pathName, name);
		to++; from = to;
		if (stat (pathName, &buf) != 0)
		{
			delete pathName;
			continue;
		}
		return pathName;
	}
	return 0;
}

