/* This module has some functions unique to the CM11A interface.
 * Copyright Daniel B. Suthers, 1996, 1997, Pleasanton, Ca. USA 93988
 * dbs@tanj.com
 *
 * This code may not be reused in commercial product without express
 * permission of the author.  Any re-use must include this intire
 * copyright notice, intact.
 */
 

#include <stdio.h>
#include "x10.h"

extern char hc2char();
extern unsigned int x2unitmap();

extern int Iloaded, Idays, Ihours, Iminutes, Ijday, Iseconds;
extern int Istatdim, Istatmon, Iaddmon;


extern unsigned char Ihcode;

extern char *wdays[];

/* ARGSUSED */

int c_info(argc, argv)
char *argv[];
{
    char RCSID[]= "@(#) $Id: info.c,v 1.3 1998/05/08 01:50:08 dbs Exp dbs $\n";

    if (argc != 2)
	usage(E_2MANY);
    get_status();
    if ((Iloaded && (Ihours + Iminutes + Idays + Ijday) != 0 ))
	(void) printf("Interface clock: %s, %2d:%02d:%02d\n",
		      bits2day(Idays), Ihours, Iminutes, Iseconds);
    else
	(void) printf("Interface clock not yet set\n");
    (void) printf("Housecode = %c\n", hc2char(Ihcode));
    
    (void) printf("0 = off, 1 = on,               unit  16.......8...4..1\n");

    (void) printf("Last addressed device =       0x%04x (%s)\n", Iaddmon,
            b2s(x2unitmap(Iaddmon)) );
    (void) printf("Status of monitored devices = 0x%04x (%s)\n", Istatmon,
            b2s(x2unitmap(Istatmon)) );
    (void) printf("Status of dimmed devices =    0x%04x (%s)\n", Istatdim,
            b2s(x2unitmap(Istatdim)) );
}
