/*
 * Changes for use with CM11A copyright 1996, 1997 Daniel B. Suthers,
 * Pleasanton Ca, 94588 USA
 * E-mail dbs@tanj.com
 */
/*
 * Copyright 1986 by Larry Campbell, 73 Concord Street, Maynard MA 01754 USA
 * (maynard!campbell).  You may freely copy, use, and distribute this software
 * subject to the following restrictions:
 *
 *  1)	You may not charge money for it.
 *  2)	You may not remove or alter this copyright notice.
 *  3)	You may not claim you wrote it.
 *  4)	If you make improvements (or other changes), you are requested
 *	to send them to me, so there's a focal point for distributing
 *	improved versions.
 *
 * John Chmielewski (tesla!jlc until 9/1/86, then rogue!jlc) assisted
 * by doing the System V port and adding some nice features.  Thanks!
 * 
 */

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif
#include <time.h>
#include "x10.h"
#include "version.h"
#include <syslog.h>

#ifdef __GLIBC__
/* msf - added for glibc/rh 5.0 */
#include <sys/types.h>
#endif

extern long time();
extern struct tm *localtime();
extern int tty;
extern int sptty;
extern char x10_tty[];

int x10_housecode;
int verbose;
int i_am_relay = 0;

void sigtimer();
char hc2char();

char
 syncmsg[SYNCN], flag;

char latitude[20];
char longitude[20];

struct hstruct			/* table to map housecodes into letters */
 housetab[] =
{
    {HC_A, 'a'},
    {HC_B, 'b'},
    {HC_C, 'c'},
    {HC_D, 'd'},
    {HC_E, 'e'},
    {HC_F, 'f'},
    {HC_G, 'g'},
    {HC_H, 'h'},
    {HC_I, 'i'},
    {HC_J, 'j'},
    {HC_K, 'k'},
    {HC_L, 'l'},
    {HC_M, 'm'},
    {HC_N, 'n'},
    {HC_O, 'o'},
    {HC_P, 'p'}
};

char *wdays[] =
{"Sunday", "Monday", "Tuesday", "Wednesday",
 "Thursday", "Friday", "Saturday", "<day not set>"};

/* Table for mapping units (1-16) or house codes (a-p) to 4 bit nibbles.
 * element 0 equates to unit 1 or code a
 */
unsigned char cm11map[]=
{  06, 016, 02, 012, 01, 011, 05, 015,
   07, 017, 03, 013, 0, 010, 04, 014
};

/* Table for mapping an x10 format bitmap to a unit number.  It's
 * the reverse of the one above.
 * Note that the unit numbers are 1-16, but the array is 0-15.
 */
unsigned char map2cm11[]=
{
    13, 5, 3, 11, 15, 7, 1, 9, 14, 6, 4, 12, 16, 8, 2, 10
};

int timeout = TIMEOUT, Iloaded, Iminutes, Iseconds, Ihours, Idays, Ijday;
int Istatdim, Istatmon, Iaddmon;
unsigned char Ihcode;

extern int
 c_data(), c_date(), c_delete(), c_diagnostic(), c_dump(), c_fdump(),
 c_finfo(), c_fload(), c_info(), c_monitor(), c_reset(), c_schedule(),
 c_setclock(), c_turn(), c_dbs(), c_stop(), c_erase();

int c_help(), c_version();

struct cmdentry {
    char *cmd_name;
    int (*cmd_routine) ();
} cmdtab[] = {
    "date", c_date,
    "info", c_info,
    "monitor", c_monitor,
    "reset", c_reset,
    "setclock", c_setclock,
    "status", c_turn,
    "stop", c_stop,
    "turn", c_turn,
    "erase", c_erase,
    "version", c_version,
    "help", c_help,
    "", NULL
};

char *argptr;

main(argc, argv)
int argc;
char *argv[];
{
    register i;
    int (*rtn) ();
    struct cmdentry *c;
    struct stat statb;
    char RCSID[]= "@(#) $Id: x10.c,v 1.13 1998/04/28 04:53:25 dbs Exp $\n";


    rtn = NULL;
    verbose = 1;		/* for the error message */
    if( argc > 1)
    {
	if (strcmp(argv[1], "-v") == 0 )
	{
	    verbose = 1;
	    for (i = 1; i < argc; i++ )
	    {
		argv[i] = argv[i+1];
	    }
	    argc --;
	}
	else
	    verbose = 0;
    }
    if( verbose )
	printf( "Version:%4s\n", VERSION );


    if (argc < 2)
	usage(E_NOCMD);
    for (c = cmdtab; c->cmd_routine != NULL; c++) {
	if (strcmp(argv[1], c->cmd_name) == 0) {
	    rtn = c->cmd_routine;
	    break;
	}
    }
    if (rtn == NULL)
	usage(E_INVCN);

    if( stat(SPOOLDIR, &statb) != 0 )
    {
    	fprintf( stderr, "Please build the %s directory with permissions 1777\n", SPOOLDIR);
	exit(3);
    }
    if(  (statb.st_mode & S_IRWXO) != S_IRWXO )
    {
    	fprintf( stderr, "Please change the %s directory's permissions to 2777\n", SPOOLDIR);
	exit(3);
    }
    read_config();

    if( ( strcmp("stop", c->cmd_name) == 0 ) || 
        (strcmp("version", c->cmd_name) == 0) ||
        (strcmp("help", c->cmd_name) == 0) )
    {
        (*rtn)();		/* exits */
	return(0);
    }

    argptr = argv[0];

    /* Future: A command line of 'relay' directs this copy to start the relay 
     * process.  If that's the case, don't check for relay.
     */
    if( strcmp("relay", c->cmd_name) != 0 )
    {
	start_relay(x10_tty);


	if( ! i_am_relay )
	{
	    setup_sp_tty();
	}
    }


#ifdef MINIEXCH
    mxconnect(MINIXPORT);
#endif

    init(c->cmd_name);

    (*rtn) (argc, argv);
    return 0;
}

/*
 * Convert X10-style day of week (bit map, bit 0=monday, 6=sunday)
 * to UNIX localtime(3) style day of week (integer, 0=sunday)
 */
/* DBS  NOTE:  This is valid for CP290, not for CM11A.
 * The CM11A uses unix style.
 */


dowX2U(b)
register char b;
{
    register n;

    for (n = 1; (!(b & 1)) && n < 8; n++, b = b >> 1)
    	;
    if (n == 7)
	n = 0;
    if (n == 8)
	n = 7;
    return (n);
}

dowU2X(d)
register d;
{
    if (d == 0)
	d = 7;
    return (1 << (d - 1));
}

init(cmd_name)
char * cmd_name;
{
    int n;
    unsigned int batlife;
    unsigned char buf[30];
    char *bits2day();
    int get_status();

    timeout = TIMEOUT;
    if( strcmp(cmd_name, "monitor") == 0 )
    {
	check4poll(1,2);
    }
    else
	check4poll(0,0);

    /* Now check the status of the interface. */
    /* if( get_status() < 1)
        error("could not get the interface status");
    */
}


/* 
 * chksum is used to check the CM11A's acknowledgment to the
 * data we send it.  It's a simple addition of all bytes.
 */
chksum(buf, size)
unsigned char *buf;
int size;
{
    register int i, sum;

    for (i = 0, sum = 0; i < size ; i++)
	sum += buf[i];
    return (sum & 0xFF);
}

char hc2char(code)
unsigned code;
{
    register i;

    for (i = 0; i < 16; i++)
	if (housetab[i].h_code == code)
	    return i + 'a';
    return ('?');
}

char2hc(hletter)
int hletter;
{
    if (isupper(hletter))
	hletter = tolower(hletter);
    if ('a' <= hletter && hletter <= 'p')
        return housetab[hletter - 'a'].h_code;
    else
	error("invalid house code");
}

/*
 * Parse string of comma-separated unit numbers and return bitmap
 * (big-endian) of units specified.  '*' means "all units".
 */

getunits(p)
register char *p;
{

#define DIGBUFN 80		/* maximum line length */

    unsigned bitmsk, n, unit, lastunit, range;
    char digbuf[DIGBUFN];

    bitmsk = 0;
    lastunit = 0;
    range = 0;
    while (*p) {
	if (*p == '*') {
	    bitmsk = 0xFFFF;
	    break;
	}
	for (n = 0; n < DIGBUFN && isdigit(*p); n++, p++)
	    digbuf[n] = *p;
	digbuf[n] = '\0';
	if ((unit = atoi(digbuf)) < 1 || unit > 16)
	    error("bad unit code, must be between 1 and 16");

	bitmsk |= (0x01 << (unit-1)) ;
	if( range == 1)
	{
	    for( n = lastunit; n <= unit; n++)
		bitmsk |= (0x01 << (n-1)) ;
	}

	if (*p)
	    if (*p == '-') {
		lastunit = unit;
		range = 1;
		p++;
	    } else if (*p == ',') {
		lastunit = 0;
		range=0;
		p++;
	    } else {
		error("bad unit separator, use comma or dash please");
	    }
    }
    return (bitmsk);
}

dimstate(p, level)
register char *p, *level;
{
    unsigned levelnum;
    unsigned dim;

    dim = 0;
    if (strcmp(p, "on") == 0)
	return (2);
    if (strcmp(p, "off") == 0)
	return (3);
    if (strcmp(p, "dim") == 0)
	dim = 4;
    if (strcmp(p, "bright") == 0)
	dim = 5;
    if (dim == 0)
	error("bad state keyword");
    if (sscanf(level, "%d", &levelnum) == 0)
	error("dim value must be numeric");
    if (levelnum > 23)
	error("dim value out of range, must be between 0 and 23");
    timeout = DTIMEOUT;
    return ((levelnum << 3) | dim);
}

struct nstruct dtab[] =
{
    "monday", 0x01,
    "tuesday", 0x02,
    "wednesday", 0x04,
    "thursday", 0x08,
    "friday", 0x10,
    "saturday", 0x20,
    "sunday", 0x40,
    "everyday", 0x7f,
    "weekdays", 0x1f,
    "weekends", 0x60,
    "", 0x00
};

day2bits(p)
char *p;
{
    char c, buf[6];
    int n, mask, length;

    if (strcasecmp(p,"Today") == 0)
    	return (Idays);
    length = strlen(p);
    mask = 0;
    for (n = 0; dtab[n].n_name[0] != 0; n++) {
	if (strncasecmp(dtab[n].n_name, p, length) == 0) {
	    if (mask != 0)
		error("ambiguous day abbreviation");
	    mask = dtab[n].n_code;
	}
    }
    if (mask == 0)
	error("bad day keyword");
    return (mask);
}

#define MODULES 25
#define NAME_LEN 20
#define UNIT_LEN 50

struct x10_mod {
	char name[NAME_LEN+1];
	char hc;
	char un[UNIT_LEN];
} x10_modules[MODULES];


read_config()
{

	char line[256];
	char alias[50];
	char housecode[50];
	char unit[UNIT_LEN];
	char *configfile;
	char * home;
	static FILE *f = NULL;
	int i = 0;
	int n;
	extern char *getenv();

	if (f) return;

	configfile = getenv("X10CONFIG");
	if (configfile == NULL)
	{
	    home=getenv("HOME");
	    if( home == NULL )
	    {
	        home = ".";
	    }
		(void) strcat(strcpy(line, home), ALIASFILE);
		configfile = line;
	}

	if( verbose )
		fprintf(stderr,
		    "Using the config file %s\n", configfile);
	f = fopen(configfile,"r");
	if (!f) {
		err("couldn't open configfile %s: is $X10CONFIG set?",
			configfile);
		exit(1);
	}

	clearerr(f);
	for (;;)
	{
		line [0] = '\0';

		fgets(line, 255, f);

		if ((line[0] == '\0') || (line[0] == 0x0a) )
		    if( feof(f)  != 0 )		/* end of file */
			break;
		    else
			continue;		/* blank line */

		if (i >= MODULES)
		{
		    err("out of table space for config", NULL);
		    break;
		}

		n = sscanf(line, "%s %s %s", alias, housecode, unit);

		if (!n || alias[0] == '#')
			continue;

		switch(n)
		{
		    case 3:
		    case 2:
			if (strcmp(alias, "TTY") == 0)
			{
				/* special case */
				strcpy(x10_tty, housecode);
				break;
			}
			if (strcmp(alias, "LATITUDE") == 0)
			{
				/* another special case */
				strncpy(latitude, housecode, 
						sizeof(latitude));
				continue;
			}
			if (strcmp(alias, "LONGITUDE") == 0)
			{
				/* another special case */
				strncpy(longitude, housecode, 
						sizeof(longitude));
				continue;
			}
			if (strcmp(alias, "HOUSECODE") == 0)
			{
				/* another special case */
				x10_housecode = char2hc(housecode[0]);
				continue;
			}
			housecode[1] = '\0';
			if (isupper(housecode[0]))
				housecode[0] = tolower(housecode[0]);
			if (housecode[0] < 'a' || housecode[0] > 'p') {
				err("bad housecode in config, alias %s",
					alias);
				continue;
			}
			x10_modules[i].hc = housecode[0];
			strncpy(x10_modules[i].un,unit,UNIT_LEN);
			strncpy(x10_modules[i].name, alias, NAME_LEN);

			++i;
			break;

		    case 1:
			err("warning: short field in line in config:\n	%s",line);
			break;
		    default:
			err("warning: too many fields in line in config:\n	%s",line);
			break;
		}

	}

	fclose (f);

}



struct x10_mod *
xmod_lookup(name)
char *name;
{
	int i = 0;
	struct x10_mod *xm;

	xm = x10_modules;
	while (i < MODULES) {
		if (!xm->name[0])
			break;
		if (strcmp(name, xm->name) == 0)
			return xm;
		i++;
		xm++;
	}
	if (!i) {
		err("no config at all", NULL);
	}
	return NULL;
}

char *
xmod_name(hl,unit)
char *unit;
{
	int i = 0;
	struct x10_mod *xm;

	xm = x10_modules;
	if (isupper(hl))
		hl = tolower(hl);
	while (i < MODULES) {
		if (!xm->name[0])
			break;
		if (hl == xm->hc && strcmp(unit,xm->un) == 0)
			return xm->name;
		i++;
		xm++;
	}
	return NULL;
}


parse_unit(name,hcp,unitp)
char *name;
int *hcp;
char **unitp;
{
    struct x10_mod *x;
    int hletter;
    static int unitnum[5];

    if (isalpha(name[0]) && (isdigit(name[1]) || name[1] == '*')) {
	hletter = name[0];
	if (isupper(hletter))
	    hletter = tolower(hletter);
	*unitp = &name[1];
    } else {
	x = xmod_lookup(name);
	if (!x) {
		err("bad alias %s",name);
		quit();
	}
	hletter = x->hc;
	*unitp = x->un;
    }
    *hcp = char2hc(hletter);

}


err(m,s)
char *m, *s;
{
	fprintf(stderr, "heyu: ");
	fprintf(stderr, m, s);
	fprintf(stderr, "\n");
}

#ifdef DEBUG
/* dump config is a debugging tool used to see if the 10_mod link list is ok */
dump_config()
{
	int i = 0;
	struct x10_mod *xm = x10_modules;
	extern char x10_tty[];
	while (i < MODULES) {
		if (!xm->name[0])
			break;
		printf("%d: name: %s, housecode is %c, unit %s\n",
			i, xm->name, xm->hc, xm->un);
		i++;
		xm++;
	}
	if (!i)
		err("no config at all", NULL);

	if (x10_tty[0])
		printf("tty is %s\n", x10_tty);
}
#endif


/* 
 *  The CM11A sends data back to the computer whenever it sees a command
 *  come in over the AC buss.  This should (theoretically) allow the compuer
 *  to track the status of all modules.  Upon startup, this program should
 *  check for a poll before anything else.
 *
 *  Check for a poll (0x5a) from the CM11A, If we get one within a
 *  second, we should send 0xc3 to tell it that we are ready to read
 *  it's output.
 *
 *  If the showdata flag is set, we print.  Otherwise we just eat the output.
 */
check4poll(showdata, timeout)
int showdata;
int timeout;
{
    int n, i;
    int to_read;
    char hc;
    int unit;
    int macro_report;
    char *func;
    int funcbits;
    static int wasflag = 0;
    unsigned char buf[15];
    char statstr[80];
    extern char *funcmap[];
    extern char *b2s();
    time_t timestore;
    struct tm *tp;
    off_t f_offset;

    unit = -1;
    hc = '\0';
    func =  "" ;

    if( showdata )
    {
	timestore = 0;
	time(&timestore);
	tp = localtime(&timestore);
	sprintf(statstr, "%s at %02d:%02d:%02d ",
	wdays[tp->tm_wday], tp->tm_hour, tp->tm_min, tp->tm_sec);

    }
    if( timeout == 0 )		/* only do a read if there is data */
    {
	if( sptty < 0 )
	    return(0);
        f_offset = lseek(sptty, 0, SEEK_CUR);
	if( f_offset == lseek(sptty, 0, SEEK_END) )
	    return(0);
	lseek(sptty, f_offset, SEEK_SET);
	timeout = 1;
    }
    n = xread(sptty, buf, 1, timeout);
    if( n != 0 )
    {
	while( buf[0] == 0xff ) /* CM11A has polling info for me */
	{
	    if( ++wasflag == 3)
	    {
		wasflag = 0;
		n = xread(sptty, buf, 1, timeout);	/* length of xmit */
		if( n != 1 )
		     return(0);
		n = buf[0];
		if( showdata )
		    printf("%s %s ...", statstr,
		    (n < 127)? "Transmitted data" : "Response to transmision");
		if( n > 127)
		    n -= 127;
		n = xread(sptty, buf, n, timeout); /* read entire transmision */
		for( i = 0; i < n; i++)
		    printf( "%02x%s", buf[i], i == (n-1) ? "\n" : " ");
		
	        return(0);
	    }
	    else
	    n = xread(sptty, buf, 1, timeout);
	    if( n != 1 )
	        return(0);
	}

	if( (buf[0] != 0xff) && (wasflag > 0))
	{
	    n = buf[0];
	    for(i = 0; i < wasflag;i++)
		buf[i] == 0xff;
	    buf[i] = n;
	    wasflag = 0;
	}
	    
	macro_report = 0;
        if( buf[0] == 0x5a ) /* CM11A has polling info for me */
	{
	    /* The xread is executed a second time on failure because the
	       dim commands may be tieing up the CM11.
	    */
	    n = xread(sptty, buf, 1, 2);  /* get the buffer size */
	    if ( n == 0)
		n = xread(sptty, buf, 1, 5);  /* get the buffer size */
	    /* Greater than 0 means we have a byte count */
	    if ( n > 0 ) 
	    {
	        to_read = buf[0];	/* number of bytes to read */
		if( to_read == 0x5a)
		{
		    timeout = 2;
		    return(check4poll(showdata, timeout));
		}
		else if (to_read == 0x5b)
		{
		    to_read = 2;
		    macro_report = 1;
		}
		if( to_read > sizeof(buf) )
		{
		    if( verbose )
			fprintf(stderr, "Polling read size exceeds buffer");
		    return(-1);
		}
		n = xread(sptty, buf, to_read , timeout);
		if ( n != to_read )
		{
		    fprintf( stderr, "Poll only got %d of %d bytes\n",
		            n, to_read);
		    return(0);
		}
                if( showdata > 0 && (verbose != 0) )
		    fprintf( stderr, "I received a poll %d bytes long.\n", n);


		/* DEBUG 
		fprintf( stderr, "byte 0 = %0x (%s)\n", buf[0], b2s( buf[0]) );
		DEBUG */

		if( macro_report == 1 ) /* CM11A is reporting a macro execution.*/
		{
		    if( showdata )
			fprintf( stderr, "%s executed macro   : macro executed at eeprom address %d\n",
				statstr, ((buf[0] & 0x07) << 8) + buf[1] );

		}
		else
		{
		    for ( i = 1; i < to_read; i++)
		    {
			/* DEBUG 
			fprintf( stderr, "byte %d = %0x\n", i, buf[i]);
			DEBUG */ 

			if( strcmp( func, "Dim") == 0)
			{
			    if( showdata )
				fprintf( stderr, "dimmed by %%%02.0f\n",
					(float)buf[i]/(float)210 * 100);
			    func = "";
			}
			else if( strcmp( func, "Bright") == 0 )
			{
			    if( showdata )
				fprintf( stderr, "brightened by  %%%02.0f\n",
					(float)buf[i]/(float)210 * 100 );
			    func = "";
			}
			else if( (buf[0] & (0x01 << (i-1))) != 0)   /* a function */
			{
			    char *nl;
			    hc = hc2char( ((buf[i] & 0xF0) >> 4) );
			    funcbits = buf[i] & 0x0F;
			    func = funcmap[ buf[i] & 0x0F];
			    /* continue the line if function is dim or bright */
			    if( funcbits == DIM || funcbits == BRIGHT )
				    nl = ", ";
			    else
				nl = "\n";
				
			    if( showdata )
				fprintf( stderr, "%s function  %06s : housecode %c%s",
					statstr, func, hc, nl);
			}
			else		/* an address */
			{
			    hc = hc2char( ((buf[i] & 0xF0) >> 4) );
			    unit = unit2int( buf[i] & 0x0F) ;
			    if( showdata )
				fprintf( stderr, "%s address unit %3d : housecode %c\n",
					 statstr, unit, hc);
			}
		    }
		}
	    }
	    else
	    {
		if (verbose)
		    sprintf( statstr, "Bytes received = %d,", n);
		fprintf( stderr, 
		        "%s The interface didn't answer a getinfo response.\n",
			statstr);
	    }
	}
        else if( (buf[0] == 0xa5) )
	{				/* CM11A is asking for time update */
	    fprintf(stderr, "Module experienced a power failure. %s",
	            "It requested a time update.\n");
	}
	else if( buf[0] == 0x5b) 
	{
		to_read = 2;
		n = xread(sptty, buf, to_read, timeout);
		if(showdata)
		{
		    fprintf(stderr, "%s executed macro at EEPROM address %d\n",
				statstr, (((buf[0] & 0x07)<<8) + buf[1])); 
		    /*   TEST CODE
		    fprintf(stderr, "( EEPROM byte 0 = %d, Byte 1 = %d)\n",
				 (buf[0] & 0x07), (buf[1])); 
		    */
		}
	}
	else
	    fprintf( stderr,
	        "%s Poll received unknown value (%d bytes), leading byte = %0x\n",
		statstr, n, buf[0]);
    }
    return(0);
}

/* Takes the bits in CM11A format (as used in the reply to a status) 
 * and returns a day string.
 * The b parameter is for bitmap */
char *bits2day(b)
int b;
{
   
   switch(b)
   {
       case 1:
	   return("Sun");
       case 2:
	   return("Mon");
       case 4:
	   return("Tue");
       case 8:
	   return("Wed");
       case 16:
	   return("Thu");
       case 32:
	   return("Fri");
       case 64:
	   return("Sat");
    }
}

c_version()
{
	printf( "Version:%4s\n", VERSION );
}

c_help()
{
    usage(NULL);
}
