
/*
 * Copyright 1986 by Larry Campbell, 73 Concord Street, Maynard MA 01754 USA
 * (maynard!campbell).  You may freely copy, use, and distribute this software
 * subject to the following restrictions:
 *
 *  1)	You may not charge money for it.
 *  2)	You may not remove or alter this copyright notice.
 *  3)	You may not claim you wrote it.
 *  4)	If you make improvements (or other changes), you are requested
 *	to send them to me, so there's a focal point for distributing
 *	improved versions.
 *
 * John Chmielewski (tesla!jlc until 9/1/86, then rogue!jlc) assisted
 * by doing the System V port and adding some nice features.  Thanks!
 */
/* Updates for the CM11A by Daniel Suthers,
 * Copyright 1997, Pleasanton, Ca, Usa
 * E-mail dbs@tanj.com
 */

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include "x10.h"

unsigned alarm();
void sigtimer();
#ifdef __linux__
#include <sys/time.h>
#include <unistd.h>
#endif

/*
 * xread(fd, buf, count, timeout)
 *
 *	Timed read.  Works just like read(2) but gives up after
 *	timeout seconds, returning whatever's been read so far.
 */
/*  NOTE:  The CM11A will pop out a poll message every second when it wants
 *  to send an update.  Alarm(1) will go off when the next second starts.
 *  This may be any amount of time up to 1 second.  This makes a normal
 *  alarm(1) unsuitable.  Thus the use of setitimer.  Other OSes will have
 *  similar capabilities that assure a 1 second alarm is actually one second.
 */

static jmp_buf jb;

xread(fd, buf, count, timeout)
unsigned char *buf;
{
    int total;
#ifdef __linux__
    struct timeval old, current;
    struct itimerval iold, icurrent;
    struct timezone tz;
#endif
    extern int i_am_relay;
    char RCSID[]= "@(#) $Id: xread.c,v 1.4 1997/12/07 22:24:48 dbs Exp $\n";

    total = 0;
    if (setjmp(jb))
    {
	return (total);
    }

    (void) signal(SIGALRM, sigtimer);
#ifdef __linux__
    icurrent.it_value.tv_sec = (timeout -1) >= 0 ? (timeout - 1) : 0 ;
    icurrent.it_value.tv_usec = 1000000;	/* one second */
    setitimer(ITIMER_REAL, &icurrent, &iold);
#else
    (void) alarm((unsigned) timeout);
#endif


    while (count--) {
	int i;
	if ((i = read(fd, (char *) buf, 1)) < 1) {
	    if( (i < 0) && (i_am_relay != 1) )
	        perror("read");
	    if( i == 0 )
	    {
	        count ++;
		continue;
	    }
	    (void) alarm(0);
	    (void) signal(SIGALRM, SIG_IGN);
	    return (total);
	}
	buf++;
	total++;
    }
    (void) alarm(0);
    (void) signal(SIGALRM, SIG_IGN);
    return (total);
}

void sigtimer()
{
    longjmp(jb, 1);
}


/* expect xread sends a code to the spool file that species how many
 * incoming characters are to be discarded.
 * The code is 3 0xff followed by (the number of bytes to expect +127)
 */
exread(fd, buf, count, timeout)
int fd;
char *buf;
int count;
int timeout;
{
    char lbuf[160];
    extern int sptty;

    lbuf[1] = lbuf[2] = lbuf[0] = 0xff;
    lbuf[3] = count+127;
    write( sptty, lbuf , 4);

    return(xread( fd, buf, count, timeout));
}

