; Aisleriot - osmosis.scm
; Copyright (C) 1998 Rosanna Yuen <rwsy@mit.edu>
;
; This game is free software; you can redistribute it and/or
; modify it under the terms of the GNU Library General Public
; License as published by the Free Software Foundation; either
; version 2 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Library General Public License for more details.
;
; You should have received a copy of the GNU Library General Public
; License along with this library; if not, write to the Free
; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

(define FLIP-COUNTER 0)

(define (new-game)
  (initialize-playing-area)
  (set-ace-low)
  (make-standard-deck)
  (shuffle-deck)

  (add-extended-slot '() right)      ;Slot 0
  (add-blank-slot)
  (add-extended-slot '() right)      ;Slot 1
  (add-carriage-return-slot)
  (add-extended-slot '() right)      ;Slot 2
  (add-blank-slot)
  (add-extended-slot '() right)      ;Slot 3
  (add-carriage-return-slot)
  (add-extended-slot '() right)      ;Slot 4
  (add-blank-slot)
  (add-extended-slot '() right)      ;Slot 5
  (add-carriage-return-slot)
  (add-extended-slot '() right)      ;Slot 6
  (add-blank-slot)
  (add-extended-slot '() right)      ;Slot 7
  (add-carriage-return-slot)
  (add-normal-slot DECK)             ;Slot 8
  (add-normal-slot '())              ;Slot 9

  (deal-cards 8 '(0 2 4 6 0 2 4 6 0 2 4 6))
  (deal-cards-face-up 8 '(0 2 4 6 1))
  (set! FLIP-COUNTER 0)
  (list 6 5)
)
  
(define (button-pressed slot-id card-list)
  (and (not (empty-slot? slot-id))
       (= (list-length card-list) 1)
       (or (= slot-id 0) 
	   (= slot-id 2)
	   (= slot-id 4) 
	   (= slot-id 6)
	   (= slot-id 9))))
		
(define (complete-transaction start-slot card-list end-slot)
  (move-n-cards! start-slot end-slot card-list)
  (if (not (empty-slot? start-slot))
      (make-visible-top-card start-slot))
  #t)

(define (find-card-val-in-list? cards value)
  (and (not (null? cards))
       (or (= value (get-value (car cards)))
	   (find-card-val-in-list? (cdr cards) value))))

(define (button-released start-slot card-list end-slot)
  (and (not (= start-slot end-slot))
       (or (= end-slot 1)
	   (= end-slot 3)
	   (= end-slot 5)
	   (= end-slot 7))
       (if (empty-slot? end-slot)
	   (and (= (get-value (car (reverse (get-cards 1))))
		   (get-value (car card-list)))
		(while (empty-slot? (- end-slot 2)) 
		       (set! end-slot (- end-slot 2))))
	   (and (= (get-suit (get-top-card end-slot))
		   (get-suit (car card-list)))
		(or (= end-slot 1)
		    (find-card-val-in-list? (get-cards (- end-slot 2))
					    (get-value (car card-list))) )))
       (complete-transaction start-slot card-list end-slot)))
  
(define (flip-cards-back)
  (if (not (empty-slot? 9))
      (begin
	(add-card! 8 (flip-card (remove-card 9)))
	(flip-cards-back))))

(define (button-clicked slot-id)
  (and (= slot-id 8)
      (if (empty-slot? 8)
	  (and (< FLIP-COUNTER 3)
	       (set! FLIP-COUNTER (+ 1 FLIP-COUNTER))
	       (flip-cards-back))
	  (add-card! 9 (flip-card (remove-card 8))))))
	      
(define (button-double-clicked slot)
  #f)

(define (placeable? card slot-id)
  (and (< slot-id 9)
       (or (if (empty-slot? slot-id)
	       (and (= (get-value card) 
		       (get-value (car (reverse (get-cards 1)))))
		    (list 1 (get-name card) "an empty slot"))
	       (and (= (get-suit card) (get-suit (get-top-card slot-id)))
		    (or (= slot-id 1)
			(find-card-val-in-list? (get-cards (- slot-id 2)) 
						(get-value card)))
		    (list 2 (get-name card) 
			  (get-name (get-top-card slot-id)))))
	   (placeable? card (+ slot-id 2)))))

(define (get-valid-move id-list)
  (and (not (null? id-list))
       (or (and (not (empty-slot? (car id-list)))
		(placeable? (get-top-card (car id-list)) 1))
	   (get-valid-move (cdr id-list)))))

(define (game-over not-used)
  (or (and (< FLIP-COUNTER 3)
	   (not (empty-slot? 9)))
      (not (empty-slot? 8))
      (get-valid-move '(0 2 4 6 9))))

(define (game-won not-used)
  (and (= 13 (list-length (get-cards 1)))
       (= 13 (list-length (get-cards 3)))
       (= 13 (list-length (get-cards 5)))
       (= 13 (list-length (get-cards 7)))))

(define (get-hint not-used)
  (or (get-valid-move '(0 2 4 6 9))
      (list 0 "Deal a new card from the deck"))) ; Should be (list 3 ...)

(set-lambda new-game button-pressed button-released button-clicked button-double-clicked game-over game-won get-hint)

