/****************************************************************************/
/**                                                                        **/
/**                          Connect-4 Algorithm                           **/
/**                                                                        **/
/**                            By Keith Pomakis                            **/
/**                     (kppomaki@jeeves.uwaterloo.ca)                     **/
/**                                                                        **/
/**                               Fall, 1993                               **/
/**                                                                        **/
/****************************************************************************/
/**                                                                        **/
/**                  See the file "c4.c" for documentation.                **/
/**                                                                        **/
/****************************************************************************/

#ifndef C4_DEFINED
#define C4_DEFINED

#define EMPTY   2

#ifndef Boolean
#define Boolean unsigned char
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef struct {

    char **board;           /* The board configuration of the game state.  */
                            /* board[x][y] specifies the position of the   */
                            /* xth column and the yth row of the board,    */
                            /* where column and row numbering starts at 0. */
                            /* (The 0th row is the bottom row.)            */
                            /* A value of 0 specifies that the position is */
                            /* occupied by a piece owned by player 0, a    */
                            /* value of 1 specifies that the position is   */
                            /* occupied by a piece owned by player 1, and  */
                            /* a value of EMPTY specifies that the         */
                            /* position is unoccupied.                     */

    long *(score_array[2]); /* An array specifying statistics on both      */
                            /* players.  score_array[0] specifies the      */
                            /* statistics for player 0, while              */
                            /* score_array[1] specifies the statistics for */
                            /* player 1.  These statistics have little     */
                            /* meaning outside the realm of the local      */
                            /* functions of the "c4.c" file.               */

    long num_of_pieces;     /* The number of pieces currently occupying    */
                            /* board spaces.                               */

} Game_state;


/* See the file "c4.c" for documentation on the following functions. */

extern void poll(void (*poll_func)(void), long level);
extern void new_game(long width, long height, long num);
extern Boolean make_move(long player, long column);
extern long automatic_move(long player, long level);
extern Game_state get_game_state(void);
extern long score_of_player(long player);
extern Boolean is_winner(long player);
extern Boolean is_tie(void);
extern void win_coords(long player, long *x1, long *y1, long *x2, long *y2);
extern void end_game(void);

#endif /* C4_DEFINED */
