.\" Man page for xdemineur, Copyright (c) 1993 Marc Baudoin
.TH XDEMINEUR 6 "14 December 1993"

.SH NAME

xdemineur \- X11 minesweeper game

.SH SYNOPSIS
\fBxdemineur\fR [\fB-display\fR \fIdisplayname\fR] [\fB-l\fR \fIlines\fR]
[\fB-c\fR \fIcolumns\fR] [\fB-m\fR \fImines\fR] [\fB-ouvre\fR]

.SH DESCRIPTION

\fIXdemineur\fR is a minesweeper game for the X Window System.

The object of the game is to find the location of the mines and to mark their
location by placing a small flag.  You have exactly as many flags as there are
mines, no more, no less.  The number of flags that remain to be placed is
displayed in the top left corner and a timer is displayed in the top right
corner.

The game is played using a three buttons mouse.  The left button is used to
uncover the cell on which you click (hoping that a mine is not hidden there)
and the right button is used to place a flag (this indicates that there is a
mine here).  If you click again with the right button on a cell that has a
flag, the flag is changed into a question mark: this if you are trying to guess
the possible location of specific mines.  One more click with the right button
and the question mark disappears.  Clicking with both buttons on an uncovered
cell which has all its flags uncovers the surrounding cells (this will save a
lot of time).

The numbers displayed in uncovered cells indicate the number of mines which
are located all around (for example, a 3 means that there are three mines
within the 8 adjacent cells).  The whole game relies on the use of these
numbers.

To start playing, click randomly to uncover some cells until you find an
"opening" (a number of cells that will be uncovered at the same time) or
specify the option \fB-ouvre\fR which automatically finds an opening.

Finally, to start a new game, just click on the little yellow face above the
playfield.

.SH OPTIONS

.PP
.TP 8
\fB-display\fR \fIdisplayname\fR
Specifies which X display to use.
.TP 8
\fB-l\fR \fIlines\fR
Sets the number of lines of the playfield (the default is 16).
.TP 8
\fB-c\fR \fIcolumns\fR
Sets the number of columns of the playfield (the default is 30).
.TP 8
\fB-m\fR \fImines\fR
Sets the number of mines of the playfield (by default: number_of_lines *
number_of_columns / 4.8). If \fImines\fR is greater that the number of cells in
the playfield, this formula is used instead.
.TP 8
\fB-ouvre\fR
Automatically finds an opening to start the game.

.SH BUGS

Please report any bug you could find in xdemineur to baudoin@ensta.fr.  Also,
you should tell me the customizations you may have done, such as adding new
functions to the game or making modifications to allow the game to run on
your system.

.SH COPYRIGHT

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  The author makes no representations about
the suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

.if \n(.t<30v .bp
.SH AUTHOR

Marc Baudoin (baudoin@ensta.fr)

        |\\
      |\\| \\
      |//  )
    |\\ /  /        /\\/\\_
    |//  /        /. . /
  |\\ /  /     ___/    |_
  |//  /     (____/    /_/\\_
   |__|      (_____/ __     >
 /| ___  ________ _< \\ \\__  >
 \\|| __\\| _|_   _/ \\\\ \\___\\/      \" I know, it's awful
   | __\\____ | |/ _ \\\\    >
 /||___\\_____|___/ \\_\\\\  _>
 \\|____           ____ \\|
   \\   \\_________/   /
    \\   _    _      /
     \\_//   //_____/
       (_   \\ (_  _\\
         |/\\|   \\/

Ecole Nationale Superieure de Techniques Avancees (ENSTA)
.br
32, boulevard Victor - 75015 Paris - France
