/* libcqcam - shared Color Quickcam routines
 * Copyright (C) 1996-1998 by Patrick Reynolds
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

// definitions for the xview and Tcl/Tk control panels.

#ifndef XQCCTL_H
#define XQCCTL_H

#ifdef REMOTE

#include <camera.h>

int xqc_poll(camera_t *cam);
int xqc_fork(int argc, char *argv[], camera_t *cam, char *dpy_name);
void xqc_quit(void);
void xqc_adj(camera_t *cam);

struct xqc_msg {
  char type;    // type of message: what to adjust/do
  long value;   // adjustment value (undefined in some cases)
};

// camera adjustment types
#define XQC_BRIGHTNESS 'B'
#define XQC_BLACK_LEVEL 'b'
#define XQC_WHITE_LEVEL 'W'

// color adjustment types
#define XQC_RED 'R'
#define XQC_GREEN 'G'
#define XQC_BLUE 'l'   // B and b are taken

// control types
#define XQC_STARTUP '0'
#define XQC_QUIT 'Q'
#define XQC_STATUS 's'
#define XQC_TAKE 't'
#define XQC_ADJUST 'j'

// color/brightness slider synchronization message types
#define SEND_BRIGHT '1'
#define SEND_RED '2'
#define SEND_GREEN '3'
#define SEND_BLUE '4'

#endif // ifdef REMOTE

// auto-action constants
#define AUTO_BRIGHT 1
#define AUTO_BAL 2
#define AUTO_SAVE 4

#endif // ifndef XQCCTL_H
