////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mark@danks.org
//
// Implementation file
//
//    Copyright (c) 1997-1998 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "depth.h"

CPPEXTERN_NEW(depth)

/////////////////////////////////////////////////////////
//
// depth
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
depth :: depth()
       : m_state(1)
{ }

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
depth :: ~depth()
{ }

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void depth :: render(GemState *)
{
    if (m_state) glDisable(GL_DEPTH_TEST);
}

/////////////////////////////////////////////////////////
// postrender
//
/////////////////////////////////////////////////////////
void depth :: postrender(GemState *)
{
    if (m_state) glEnable(GL_DEPTH_TEST);
}

/////////////////////////////////////////////////////////
// depthMess
//
/////////////////////////////////////////////////////////
void depth :: depthMess(int state)
{
    m_state = state;
    setModified();
}

/////////////////////////////////////////////////////////
// static member function
//
/////////////////////////////////////////////////////////
void depth :: obj_setupCallback(t_class *classPtr)
{
    class_addfloat(classPtr, (t_method)&depth::depthMessCallback);
}
void depth :: depthMessCallback(void *data, t_floatarg state)
{
    GetMyClass(data)->depthMess((int)state);
}
