/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

static gint in_drag = FALSE;
static gfloat drag_last_x;
static gfloat drag_last_y;
static gint drag_moved;
static gint new_image = FALSE;
static gint artificial_size = FALSE;

static void set_mouse_cursor (gint icon)
{
	GdkCursor *cursor = gdk_cursor_new (icon);
	gdk_window_set_cursor (eventbox->window, cursor);
	gdk_cursor_destroy (cursor);
}

void imagewindow_pressed(GtkWidget *widget, GdkEventButton *bevent) 
{
	switch (bevent->button)
		{
		case 1:
			in_drag = TRUE;
			drag_last_x = bevent->x;
			drag_last_y = bevent->y;
			drag_moved = 0;
			gdk_pointer_grab (eventbox->window, FALSE,
                                GDK_POINTER_MOTION_MASK |
                                GDK_BUTTON_RELEASE_MASK,
                                NULL, NULL, bevent->time);
			gtk_grab_add (eventbox);
			break;
		case 2:
			select_prev_image();
			break;
		case 3:
			gtk_menu_popup (GTK_MENU(menu_image_popup), NULL, NULL, NULL, NULL,
				bevent->button, bevent->time);
			break;
		default:
			break;
		}
}

void imagewindow_released(GtkWidget *widget, GdkEventButton *bevent) 
{
	if (gdk_pointer_is_grabbed() && GTK_WIDGET_HAS_GRAB (eventbox))
		{
		gtk_grab_remove (eventbox);
		gdk_pointer_ungrab (bevent->time);
		set_mouse_cursor (GDK_LEFT_PTR);
		}

	if (bevent->button == 1)
		{
		if (drag_moved < 4)
			select_next_image();
		}

	in_drag = FALSE;
}

void imagewindow_moved(GtkWidget *widget, GdkEventButton *bevent) 
{
	GtkAdjustment* h;
	GtkAdjustment* v;
	gfloat x, y;
	gfloat val;

	if (!in_drag || !gdk_pointer_is_grabbed()) return;

	if (drag_moved < 4)
		{
		drag_moved++;
		}
	else
		{
		set_mouse_cursor (GDK_FLEUR);
		}

	h = gtk_viewport_get_hadjustment(GTK_VIEWPORT(viewwindow));
	v = gtk_viewport_get_vadjustment(GTK_VIEWPORT(viewwindow));

	x = drag_last_x - bevent->x;
	y = drag_last_y - bevent->y;

	/* x */
	if (h->upper - h->page_size > 0)
		{
		val = (float)h->value + x;
		if (val < 0 ) val = 0;
		if (val > h->upper - h->page_size) val = h->upper - h->page_size;
		h->value = val;
		gtk_adjustment_set_value (GTK_ADJUSTMENT(h), val);
		}

	/* y */
	if (v->upper - v->page_size > 0)
		{
		val = v->value + y;
		if (val < 0 ) val = 0;
		if (val > v->upper - v->page_size) val = v->upper - v->page_size;
		v->value = val;
		gtk_adjustment_set_value (GTK_ADJUSTMENT(v), val);
		}

#ifdef HAVE_GTK_1_1
	gtk_adjustment_value_changed(h);
	gtk_adjustment_value_changed(v);
#endif

	if (debug_mode)
		printf("%f to %f @ %f + %f | mouse: %d x %d\n",h->lower, h->upper, h->value, h->page_size,
			(int)bevent->x, (int)bevent->y);


	drag_last_x = bevent->x;
	drag_last_y = bevent->y;
}

void window_resized(GtkWidget *widget, GtkAllocation *allocation)
{
	static guint16 old_viewwindow_width;
	static guint16 old_viewwindow_height;
	GtkAdjustment *h = gtk_viewport_get_hadjustment(GTK_VIEWPORT(viewwindow));
	GtkAdjustment *v = gtk_viewport_get_vadjustment(GTK_VIEWPORT(viewwindow));
	guint16 width = allocation->width - 4;
	guint16 height = allocation->height - 4;

	if (debug_mode) printf("sized to %d x %d\n",width,height);

	if (artificial_size)
		{
		if (debug_mode) printf("artificial size, cancelled\n");
		return;
		}

	if (width == imagewindow->allocation.width && height == imagewindow->allocation.height)
		return;

	if (old_viewwindow_width == width &&
		old_viewwindow_height == height) return;
	old_viewwindow_width = width;
	old_viewwindow_height = height;

	/* adjust the adjustments :) */
	gtk_adjustment_clamp_page(h, 0.0, width);
	gtk_adjustment_clamp_page(v, 0.0, height);

#ifdef HAVE_GTK_1_1
	gtk_adjustment_changed(h);
	gtk_adjustment_changed(v);
#endif

	if (ZOOM != 0) return;
	image_redraw(ZOOM);


#ifndef HAVE_GTK_1_1
	if (!popwindow) gtk_widget_set_usize(mainwindow, mainwindow->allocation.width, mainwindow->allocation.height);
#endif

}

void image_redraw(gint zoom_size)
{
	gint w, h;
	gfloat scalefactor = 1;
	gint ww, wh;

	if (!image) return;
	if (!image->rgb_width || !image->rgb_height) return;

	w = image->rgb_width;
	h = image->rgb_height;
	ww = (eventbox)->allocation.width - 4;
	wh = (eventbox)->allocation.height - 4;

	if (zoom_size == 0)
		{
		if (!(new_image && popwindow && fit_window) && (w > ww || h > wh))
			{
			if ((gfloat)ww / w > (gfloat)wh / h)
				{
				scalefactor = (gfloat)wh / h;
				h = wh;
				w = w * scalefactor;
				if (w > ww) w = ww;
				}
			else
				{
				scalefactor = (gfloat)ww / w;
				w = ww;
				h = h * scalefactor;
				if (h > wh) h = wh;
				}
			if (w < 1 || h < 1)
				{
				w = 1;
				w = 1;
				}
			}
		else if (new_image && popwindow && fit_window && limit_window_size)
			{
			gint sw = (gdk_screen_width() * max_window_size / 100) - 4;
			gint sh = (gdk_screen_height() * max_window_size / 100) - 4;

			if (w > sw || h > sh)
				{
				if ((gfloat)sw / w > (gfloat)sh / h)
					{
					scalefactor = (gfloat)sh / h;
					h = sh;
					w = w * scalefactor;
					if (w > sw) w = sw;
					}
				else
					{
					scalefactor = (gfloat)sw / w;
					w = sw;
					h = h * scalefactor;
					if (h > sh) h = sh;
					}
				}
			}
		}
	if (zoom_size > 1)
		{
		scalefactor = zoom_size;
		w = w * scalefactor;
		h = h * scalefactor;
		}
	if (zoom_size < -1)
		{
		scalefactor = ( - zoom_size);
		w = w / scalefactor;
		h = h / scalefactor;
		}
	set_zoom_label(ZOOM,scalefactor);

	size_window(w, h);

#ifdef HAVE_GTK_1_1
	if (popwindow && fit_window)
		{
		/* this is hacky */
		artificial_size = TRUE;
		gtk_grab_add (fileinfolabel);
		while(gtk_events_pending()) gtk_main_iteration();
		gtk_grab_remove(fileinfolabel);
		artificial_size = FALSE;
		}
#endif

	gtk_widget_set_usize (viewtable, w, h);
	gtk_drawing_area_size(GTK_DRAWING_AREA(imagewindow),w, h);
}

void update_image()
{
	GdkImlibImage	*im;
	gchar s[256];
	gint image_is_valid = TRUE;
/*	GtkAdjustment *h = gtk_viewport_get_hadjustment(GTK_VIEWPORT(viewwindow));
	GtkAdjustment *v = gtk_viewport_get_vadjustment(GTK_VIEWPORT(viewwindow));
*/	
	sprintf(current_path,"%s/%s",image_dir_name,image_file_name);
	if (debug_mode) printf("load:%s\n",current_path);
	im=gdk_imlib_load_image(current_path);

	if (!im)
		{
		im=gdk_imlib_create_image_from_xpm_data((gchar **)img_unknown_xpm_data);
		image_is_valid = FALSE;
		}

	if (image) gdk_imlib_destroy_image(image);
	image=im;

	sprintf(s,"GQview - %s",image_file_name);
	gtk_window_set_title(GTK_WINDOW(mainwindow),s);
	if (image_is_valid)	
		sprintf(s,"( %d x %d ) %d bytes",image->rgb_width, image->rgb_height,filesize(current_path));
	else
		sprintf(s,"( ? x ? ) %d bytes",filesize(current_path));
	if (debug_mode) printf("size:%d x %d\n",image->rgb_width, image->rgb_height);
	gtk_label_set(GTK_LABEL(fileinfolabel),s);

	new_image = TRUE;
	image_redraw(ZOOM);
	new_image = FALSE;

/* this resets the area to the upper-left for the new image, but it causes an
   unwanted flash when the old image is scrolled before the new one is shown. hmm.
   removed until this is smoothed over.
	gtk_adjustment_set_value(GTK_ADJUSTMENT(h), 0.0);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(v), 0.0);*/
}

void draw_img(GtkWidget *widget, GtkAllocation *allocation)
{
	GdkBitmap *mask;
	static gchar *oldimagepath = NULL;
	static guint16 oldimagewidth = 0;
	static guint16 oldimageheight = 0;

	if (oldimagepath && strcmp(oldimagepath, current_path) == 0)
		{
		if (oldimagewidth == allocation->width &&
			oldimageheight == allocation->height) return;
		}

	if (artificial_size) return;

	if (oldimagepath) g_free(oldimagepath);
	oldimagepath = g_strdup(current_path);
	oldimagewidth = allocation->width;
	oldimageheight = allocation->height;

	if (debug_mode) printf("draw image\n");
	if (image_pixmap) gdk_imlib_free_pixmap(image_pixmap);
	mask = NULL;

	if (debug_mode) printf("rendered at %d x %d\n",allocation->width,allocation->height);
	gdk_imlib_render(image,allocation->width,allocation->height);
	image_pixmap=gdk_imlib_move_image(image);
	mask=gdk_imlib_move_mask(image);

	gdk_window_set_back_pixmap(imagewindow->window,image_pixmap,FALSE);
	gdk_window_shape_combine_mask (imagewindow->window, mask, 0, 0);
	gdk_window_clear(imagewindow->window);
	gdk_flush();
	if (mask) gdk_imlib_free_bitmap(mask);
}

