/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

static GtkWidget *warning_window;
static GtkWidget *file_manage_dialog;
static GtkWidget *filename_entry;

static gchar file_dialog_file_name[255];
static gchar file_dialog_dir_path[255];

static gchar *file_dialog_new_file_name;

static void warning_dialog_close();
static void copy_current_file_info();
static void copy_current_image_info();
static void file_manage_close();
static void dir_create_confirmed();
static void file_rename_confirmed();
static void file_rename_dialog();
static void file_delete_confirmed();
static void file_delete_dialog();
static void file_move_overwrite_confirmed();
static void file_copy_overwrite_confirmed();

static void warning_dialog_close()
{
	gtk_widget_destroy(warning_window);
	warning_window = NULL;
}

void warning_dialog(gchar *title, gchar *message)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;

	warning_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (warning_window), "delete_event",(GtkSignalFunc) warning_dialog_close, NULL);
	gtk_window_set_policy (GTK_WINDOW(warning_window), FALSE, FALSE, TRUE);
	gtk_window_set_title (GTK_WINDOW (warning_window), title);
	gtk_container_border_width (GTK_CONTAINER (warning_window), 10);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(warning_window),vbox);
	gtk_widget_show(vbox);

	label = gtk_label_new(message);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	label = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(TRUE, 5);
	gtk_container_add(GTK_CONTAINER(vbox),hbox);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("     Ok     ");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) warning_dialog_close, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_widget_show(button);
	
	gtk_widget_show(warning_window);
}

static void copy_current_file_info()
{
	strcpy(file_dialog_file_name,current_file);
	strcpy(file_dialog_dir_path,current_dir);
}

static void copy_current_image_info()
{
	strcpy(file_dialog_file_name,image_file_name);
	strcpy(file_dialog_dir_path,image_dir_name);
}

static void file_manage_close()
{
	if (!file_manage_dialog) return;
	gtk_widget_destroy(file_manage_dialog);
	file_manage_dialog = NULL;
}

static void dir_create_confirmed()
{
	gchar new_path[500];
	gchar *new_dirname;

	new_dirname = gtk_entry_get_text(GTK_ENTRY(filename_entry));
	sprintf(new_path,"%s/%s",file_dialog_dir_path,new_dirname);
	if ( (mkdir (new_path, 0755) < 0) )
		{
		/* creation failed */
		gchar s[300];
		sprintf(s,"Unable to create the directory:\n%s",new_path);
		warning_dialog("Create failed",s);
		}
	else
		{
		if (!strcmp(current_dir,file_dialog_dir_path)) refresh_dir();
		}
	file_manage_close();
}

void dir_create_dialog()
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;

	if (file_manage_dialog || warning_window ||!strlen(current_dir)) return;

	strcpy(file_dialog_dir_path,current_dir);

	file_manage_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (file_manage_dialog), "delete_event",(GtkSignalFunc) file_manage_close, NULL);
	gtk_window_set_policy (GTK_WINDOW(file_manage_dialog), FALSE, FALSE, TRUE);
	gtk_window_set_title (GTK_WINDOW (file_manage_dialog), "Create Directory");
	gtk_container_border_width (GTK_CONTAINER (file_manage_dialog), 10);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add (GTK_CONTAINER(file_manage_dialog),vbox);
	gtk_widget_show(vbox);

	label = gtk_label_new("New directory name:");
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	filename_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(filename_entry),"");
	gtk_box_pack_start(GTK_BOX(vbox),filename_entry,FALSE,FALSE,0);
	gtk_widget_grab_focus(filename_entry);
	gtk_widget_show(filename_entry);

	label = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("Create");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) dir_create_confirmed, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_manage_close, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_show(button);

	gtk_widget_show(file_manage_dialog);
}

static void file_rename_confirmed()
{
	gchar old_path[500];
	gchar new_path[500];
	gchar *new_filename;

	new_filename = gtk_entry_get_text(GTK_ENTRY(filename_entry));
	sprintf(old_path,"%s/%s",file_dialog_dir_path,file_dialog_file_name);
	sprintf(new_path,"%s/%s",file_dialog_dir_path,new_filename);
	if ( (rename (old_path, new_path) < 0) )
		{
		/* rename failed */
		gchar s[300];
		sprintf(s,"Unable to rename the file:\n%s",file_dialog_file_name);
		warning_dialog("Rename failed",s);
		}
	else
		{
		/* image renamed is the one displayed */
		if (!strcmp(file_dialog_file_name,image_file_name) &&
			!strcmp(file_dialog_dir_path,image_dir_name))
				{
				if (!strcmp(current_dir,file_dialog_dir_path))
					{
					strcpy(image_file_name,new_filename);
					update_image();
					}
				}
		/* image renamed is within displayed directory, update lists */
		if (!strcmp(current_dir,file_dialog_dir_path))
			{
			int i;
			int p = -1;
			for (i=0;i < filelist_count;i++)
				{
				if (strcmp(file_dialog_file_name,filelist_get_item(i)) == 0)
					p = i;
				}
			if (p >=0)
				{
				int j = 0;
				gchar *cbuf[] = { "x", };
				cbuf[0] = new_filename;

				filelist_remove_item(p);
				gtk_clist_remove(GTK_CLIST(filelist_clist),p);

				while (j < filelist_count && strcmp(new_filename,filelist_get_item(j)) > 0) j++;
				if (j >= filelist_count)
					{
					filelist_add_item(new_filename);
					j = gtk_clist_append(GTK_CLIST(filelist_clist),cbuf);
					}
				else
					{
					filelist_insert_item(new_filename,j);
					gtk_clist_insert(GTK_CLIST(filelist_clist),j,cbuf);
					}
				if (thumbnail_mode)
					{
					gchar th_buf[512];
					gint padding, padding_left;
					GdkPixmap *th_pixmap = NULL;
					GdkBitmap *th_mask = NULL;

					sprintf(th_buf,"%s/%s",current_dir,new_filename);
					padding = create_thumbnail(th_buf,&th_pixmap,&th_mask);
					padding_left = padding / 2;
					padding -= padding_left;
					gtk_clist_set_shift(GTK_CLIST(filelist_clist), j, 0, 0, padding_left);
					gtk_clist_set_pixtext (GTK_CLIST(filelist_clist), j, 0, new_filename, padding + 5, th_pixmap, th_mask);
					}
				if (p == filelist_pos)
					{
					filelist_pos = j;
					update_list_highlight(-1,filelist_pos,TRUE);
					}
				else
					{
					if (p < filelist_pos) filelist_pos--;
					if (j < filelist_pos) filelist_pos++;
					}
				}
			}
		}
	file_manage_close();
}

static void file_rename_dialog()
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;

	file_manage_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (file_manage_dialog), "delete_event",(GtkSignalFunc) file_manage_close, NULL);
	gtk_window_set_policy (GTK_WINDOW(file_manage_dialog), FALSE, FALSE, TRUE);
	gtk_window_set_title (GTK_WINDOW (file_manage_dialog), "Rename File");
	gtk_container_border_width (GTK_CONTAINER (file_manage_dialog), 10);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add (GTK_CONTAINER(file_manage_dialog),vbox);
	gtk_widget_show(vbox);

	label = gtk_label_new("Rename the file:");
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	label = gtk_label_new(file_dialog_file_name);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	label = gtk_label_new("to:");
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	filename_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(filename_entry),file_dialog_file_name);
	gtk_box_pack_start(GTK_BOX(vbox),filename_entry,FALSE,FALSE,0);
	gtk_widget_grab_focus(filename_entry);
	gtk_widget_show(filename_entry);
	gtk_entry_select_region(GTK_ENTRY(filename_entry), 0, strlen(file_dialog_file_name));

	label = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("Rename");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_rename_confirmed, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_manage_close, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_show(button);

	gtk_widget_show(file_manage_dialog);
}

static void file_delete_confirmed()
{
	gchar complete_path[500];
	sprintf(complete_path,"%s/%s",file_dialog_dir_path,file_dialog_file_name);
	if ( (unlink (complete_path) < 0) )
		{
		/* delete failed */
		gchar s[300];
		sprintf(s,"Unable to delete the file:\n%s",file_dialog_file_name);
		warning_dialog("Delete failed",s);
		}
	else
		{
		/* image deleted is within displayed directory, update lists */
		if (!strcmp(current_dir,file_dialog_dir_path))
			{
			int i;
			int p = -1;
			gchar sbuf[48];
			for (i=0;i < filelist_count;i++)
				{
				if (strcmp(file_dialog_file_name,filelist_get_item(i)) == 0)
					p = i;
				}
			if (p >=0)
				{
				filelist_remove_item(p);
				gtk_clist_remove(GTK_CLIST(filelist_clist),p);
				if (filelist_pos > p)
					{
					filelist_pos--;
					}
				}
			if (filelist_count == 1)
				sprintf(sbuf,"1 file");
			else
				sprintf(sbuf,"%d files",filelist_count);
			gtk_label_set(GTK_LABEL(statuslabel),sbuf);
			}
		/* image deleted is the one displayed, load the next */
		if (!strcmp(file_dialog_file_name,image_file_name) &&
			!strcmp(file_dialog_dir_path,image_dir_name))
				{
				if (!strcmp(current_dir,file_dialog_dir_path))
					{
					change_image_to_nearest();
					update_list_highlight(-1,filelist_pos,FALSE);
					}
				else
					change_image_to_logo();
				}
		}
	file_manage_close();
}

static void file_delete_dialog()
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;

	if (!confirm_delete)
		{
		file_delete_confirmed();
		return;
		}

	file_manage_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (file_manage_dialog), "delete_event",(GtkSignalFunc) file_manage_close, NULL);
	gtk_window_set_policy (GTK_WINDOW(file_manage_dialog), FALSE, FALSE, TRUE);
	gtk_window_set_title (GTK_WINDOW (file_manage_dialog), "Delete File");
	gtk_container_border_width (GTK_CONTAINER (file_manage_dialog), 10);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add (GTK_CONTAINER(file_manage_dialog),vbox);
	gtk_widget_show(vbox);

	label = gtk_label_new("About to delete the file named:");
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	label = gtk_label_new(file_dialog_file_name);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	label = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("Delete");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_delete_confirmed, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_grab_focus(button);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_manage_close, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_show(button);

	gtk_widget_show(file_manage_dialog);
}

static void file_move_or_copy_confirmed(gint move, gint overwrite)
{
	gchar old_path[500];
	gchar new_path[500];
	gchar *new_filename;

	sprintf(old_path,"%s/%s",file_dialog_dir_path,file_dialog_file_name);

	if (overwrite)
		new_filename = file_dialog_new_file_name;
	else
		new_filename = gtk_entry_get_text(GTK_ENTRY(filename_entry));

	if (isdir(new_filename))
		sprintf(new_path,"%s/%s",new_filename, file_dialog_file_name);
	else
		sprintf(new_path,"%s", new_filename);

	if (strcmp(old_path, new_path) == 0)
		{
		gchar s[300];
		sprintf(s,"Source and destination are the same for:\n%s",file_dialog_file_name);
		if (move)
			warning_dialog("Cannot move a file to itself",s);
		else
			warning_dialog("Cannot copy a file to itself",s);
		file_manage_close();
		return;
		}

	if (!overwrite && isfile(new_path))
		{
		GtkWidget *vbox;
		GtkWidget *hbox;
		GtkWidget *label;
		GtkWidget *button;

		file_dialog_new_file_name = g_strdup(new_filename);

		file_manage_close();

		file_manage_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_signal_connect (GTK_OBJECT (file_manage_dialog), "delete_event",(GtkSignalFunc) file_manage_close, NULL);
		gtk_window_set_policy (GTK_WINDOW(file_manage_dialog), FALSE, FALSE, TRUE);
		gtk_window_set_title (GTK_WINDOW (file_manage_dialog), "Overwrite File");
		gtk_container_border_width (GTK_CONTAINER (file_manage_dialog), 10);

		vbox = gtk_vbox_new(FALSE,5);
		gtk_container_add (GTK_CONTAINER(file_manage_dialog),vbox);
		gtk_widget_show(vbox);

		label = gtk_label_new("Overwrite file:");
		gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);

		label = gtk_label_new(new_path);
		gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);

		label = gtk_label_new("with:");
		gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);

		label = gtk_label_new(old_path);
		gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);

		hbox = gtk_hbox_new(TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
		gtk_widget_show(hbox);

		button = gtk_button_new_with_label("Overwrite");
		if (move)
			gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_move_overwrite_confirmed, NULL);
		else
			gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_copy_overwrite_confirmed, NULL);
		gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
		gtk_widget_show(button);

		button = gtk_button_new_with_label("Cancel");
		gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_manage_close, NULL);
		gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
		gtk_widget_show(button);

		gtk_widget_show(file_manage_dialog);

		return;
		}

	if (move)
		{
		if (!move_file(old_path, new_path))
			{
			gchar s[300];
			sprintf(s,"Unable to move the file:\n%s",file_dialog_file_name);
			warning_dialog("Move failed",s);
			}
		else
			{
			/* image moved is within displayed directory, update lists */
			if (!strcmp(current_dir,file_dialog_dir_path))
				{
				int i;
				int p = -1;
				gchar sbuf[48];
				for (i=0;i < filelist_count;i++)
					{
					if (strcmp(file_dialog_file_name,filelist_get_item(i)) == 0)
						p = i;
					}
				if (p >=0)
					{
					filelist_remove_item(p);
					gtk_clist_remove(GTK_CLIST(filelist_clist),p);
					if (filelist_pos > p)
						{
						filelist_pos--;
						}
					}
				if (filelist_count == 1)
					sprintf(sbuf,"1 file");
				else
					sprintf(sbuf,"%d files",filelist_count);
				gtk_label_set(GTK_LABEL(statuslabel),sbuf);
				}
			/* image moved is the one displayed, load the next */
			if (!strcmp(file_dialog_file_name,image_file_name) &&
				!strcmp(file_dialog_dir_path,image_dir_name))
					{
					if (!strcmp(current_dir,file_dialog_dir_path))
						{
						change_image_to_nearest();
						update_list_highlight(-1,filelist_pos,FALSE);
						}
					else
						change_image_to_logo();
					}
			}
		}
	else
		{
		if (!copy_file(old_path, new_path))
			{
			gchar s[300];
			sprintf(s,"Unable to copy the file:\n%s",file_dialog_file_name);
			warning_dialog("Copy failed",s);
			}
		}

	if (overwrite)
		{
		g_free(file_dialog_new_file_name);
		file_dialog_new_file_name = NULL;
		}

	file_manage_close();
}

static void file_move_overwrite_confirmed()
{
	file_move_or_copy_confirmed(TRUE, TRUE);
}

static void file_copy_overwrite_confirmed()
{
	file_move_or_copy_confirmed(FALSE, TRUE);
}

static void file_move_confirmed()
{
	file_move_or_copy_confirmed(TRUE, FALSE);
}

static void file_copy_confirmed()
{
	file_move_or_copy_confirmed(FALSE, FALSE);
}

static void file_move_or_copy_dialog(gint move)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *list;

	file_manage_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(file_manage_dialog, 300, 250);
	gtk_signal_connect (GTK_OBJECT (file_manage_dialog), "delete_event",(GtkSignalFunc) file_manage_close, NULL);
	gtk_window_set_policy (GTK_WINDOW(file_manage_dialog), FALSE, FALSE, TRUE);
	if (move)
		gtk_window_set_title (GTK_WINDOW (file_manage_dialog), "Move File");
	else
		gtk_window_set_title (GTK_WINDOW (file_manage_dialog), "Copy File");
	gtk_container_border_width (GTK_CONTAINER (file_manage_dialog), 10);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add (GTK_CONTAINER(file_manage_dialog),vbox);
	gtk_widget_show(vbox);

	if (move)
		label = gtk_label_new("Move file:");
	else
		label = gtk_label_new("Copy file:");
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	label = gtk_label_new(file_dialog_file_name);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	label = gtk_label_new("to:");
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	filename_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(filename_entry),file_dialog_dir_path);
	gtk_box_pack_start(GTK_BOX(vbox),filename_entry,FALSE,FALSE,0);
	gtk_widget_grab_focus(filename_entry);
	gtk_widget_show(filename_entry);
	gtk_entry_select_region(GTK_ENTRY(filename_entry), 0, strlen(file_dialog_dir_path));

	list = destination_widget_new(file_dialog_dir_path, filename_entry);
	gtk_box_pack_start(GTK_BOX(vbox),list,TRUE,TRUE,0);
	gtk_widget_show(list);

	label = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_widget_show(hbox);

	if (move)
		{
		button = gtk_button_new_with_label("Move");
		gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_move_confirmed, NULL);
		}
	else
		{
		button = gtk_button_new_with_label("Copy");
		gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_copy_confirmed, NULL);
		}
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) file_manage_close, NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,10);
	gtk_widget_show(button);

	gtk_widget_show(file_manage_dialog);
}

static void file_move_dialog()
{
	file_move_or_copy_dialog(TRUE);
}

static void file_copy_dialog()
{
	file_move_or_copy_dialog(FALSE);
}

void move_file_from_list()
{
	if (file_manage_dialog || warning_window || !strlen(current_file)) return;
	copy_current_file_info();
	file_move_dialog();
}

void move_file_from_image()
{
	if (file_manage_dialog || warning_window || !strlen(image_file_name)) return;
	copy_current_image_info();
	file_move_dialog();
}

void copy_file_from_list()
{
	if (file_manage_dialog || warning_window || !strlen(current_file)) return;
	copy_current_file_info();
	file_copy_dialog();
}

void copy_file_from_image()
{
	if (file_manage_dialog || warning_window || !strlen(image_file_name)) return;
	copy_current_image_info();
	file_copy_dialog();
}

void delete_file_from_list()
{
	if (file_manage_dialog || warning_window || !strlen(current_file)) return;
	copy_current_file_info();
	file_delete_dialog();
}

void delete_file_from_image()
{
	if (file_manage_dialog || warning_window || !strlen(image_file_name)) return;
	copy_current_image_info();
	file_delete_dialog();
}

void rename_file_from_list()
{
	if (file_manage_dialog || warning_window || !strlen(current_file)) return;
	copy_current_file_info();
	file_rename_dialog();
}

void rename_file_from_image()
{
	if (file_manage_dialog || warning_window || !strlen(image_file_name)) return;
	copy_current_image_info();
	file_rename_dialog();
}

